/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.sea.io;

import com.sea.utils.Utils;
import java.io.ByteArrayOutputStream;

/**
 *
 * @author Vorisek
 */
public class VorByteArrayOutputStream extends ByteArrayOutputStream {

/**
 * Creates a new byte array output stream, with a buffer capacity of the specified size, in bytes.
 * 
 * @param size the initial size.
 */
public VorByteArrayOutputStream(int size) {
  super(size);
}

/**
 * Returns internal buffer with data
 * 
 * @return 
 */
public byte[] getByteArray() {
  return buf;
}

/**
 * Returns internal count
 *
 * @return 
 */
public int getCount() {
  return count;
}

/**
 * Returns a string representation of the object. 
 * 
 * @return 
 */
public String toString() {
  return Utils.pckt2str(buf, 0, count);

}

public void writeString(String src) throws Exception {

  // String format is: delka[1B] text[0..255B] \0[1B]
  // If delka==255 -> format is: 255[1B] delka[2B] text[0..65535B] \0[1B]
  int len = src.length();
  if (len <= 254) {
    write(len);
  } else if (len <= 65535) {
    write(255);
    write(len & 0xFF);
    write((len >> 8) & 0xFF);
  } else {
    throw new Exception("String too long to be encoded");
  }
  byte[] bf = src.getBytes();
  for (int i = 0; i < bf.length; i++) {
    write(bf[i]);
  }
  write(0x00);

}

}
