/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.sea.gbgs5;

import com.sea.log.Logger;
import com.sea.utils.Watchdog;
import java.io.*;
import javax.microedition.io.*;

/**
 *
 * @author vorisek
 */
public class Slave extends Thread {
// --------------------------------------------------
// Public Properties
// --------------------------------------------------

public static final int LD_OFF = 0;
public static final int LD_ON = 1;
public static final int LD_AUTO = 2;
public static final int LD_EQUAL = 3;
public static final int LD_BLINK_FAST = 4;
public static final int LD_BLINK_SLOW = 5;

// --------------------------------------------------
// Private Constants
// --------------------------------------------------
private static final String CONNECTION_STRING = "comm:COM1;baudrate=115200;autocts=on;autorts=on"; // real

private static final int LINES_TO_SKIP = 10;

// --------------------------------------------------
// Private Properties
// --------------------------------------------------
private static Slave instance = null;
private static boolean bRunning = false;
public static final int iLogLevel = Logger.INFO;

private static InputStream in = null;
private static OutputStream out = null;

private CommConnection commConn = null;

private static A4Protocol proto;

private int out2;
private int led_out2;
private int led_gsm;
private boolean led_out2_override;
private int led_out2_override_value;
private boolean led_gsm_override;
private int led_gsm_override_value;
private boolean bForceHwReset;
private boolean bForceSleep;
private boolean bDebugAutoReport;
private int iDebugLineCount;

;


// --------------------------------------------------
// Class Code
// --------------------------------------------------
public Slave() {
  super();
  out2 = 0x00;
  led_out2 = LD_AUTO;
  led_gsm = LD_AUTO;
  led_out2_override = false;
  led_gsm_override = false;
  bDebugAutoReport = false;
  bForceSleep = false;
  bForceHwReset = false;
}

/**
 * getInstance
 */
public static Slave getInstance() {
  if (instance == null) {
    instance = new Slave();
  }
  return instance;
}

/**
 * startRunning
 */
public void startRunning() {
  bRunning = true;
  this.start();
}

/**
 * stopRunning
 */
public void stopRunning() {
  bRunning = false;
  this.interrupt();
}

/**
 * Debug printing
 */
protected static void log(String line) {
  log(line, Logger.INFO);
}

/**
 * Debug printing
 */
protected static void log(String line, int level) {
  if (iLogLevel >= level) {
    Logger.log("@Slave", line);
  }
}

/**
 * run
 */
public void run() {

  int led_out2_real;
  int led_gsm_real;

  log("Thread started", Logger.ALWAYS);

  commConn = null;
  Watchdog.getInstance().register(this);
  iDebugLineCount = 0;
  bForceHwReset = false;
  while (bRunning) {
    try {

      if (commConn == null) {
        log("Opening connection to slave - " + CONNECTION_STRING);
        openPort();
      }

      try {
        if (bForceHwReset) {
          bForceHwReset = false;
          proto.restart();
        }
        if (bForceSleep) {
          bForceSleep = false;
          proto.sleep();
        }

        led_out2_real = led_out2_override ? led_out2_override_value : led_out2;
        led_gsm_real = led_gsm_override ? led_gsm_override_value : led_gsm;
        proto.io(out2, led_out2_real, led_gsm_real, 44, 0x11);
        if ((proto.out2resp & 0x02) != 0) {
          // Command from hardware button --> accept new value from hardware
          out2 = proto.out2resp & 0x01;
        }

        if (bDebugAutoReport) {
          if (iDebugLineCount++ > LINES_TO_SKIP) {
            printReport();
            iDebugLineCount = 0;
          }
        }

        sleep(100);
      } catch (InterruptedException interruptedException) {
        // Interrupted exception is not handled, because it is used to speed up reaction to output command  
      }

      // SW Watchdog
      Watchdog.getInstance().kick(this, 10);

    } catch (Exception e) {
      // An exception occured. Go the interrupted step again.
      log("[ EXCEPTION ] - '" + e.toString() + "'", Logger.ERROR);
      e.printStackTrace();

    }
  }

  closePort();
  log("Thread finished", Logger.ALWAYS);

}

/**
 * openPort()
 */
private void openPort() throws IOException {
  // Open ASC port to configurator
  commConn = (CommConnection) Connector.open(CONNECTION_STRING, Connector.READ_WRITE, true);
  in = commConn.openInputStream();
  out = commConn.openDataOutputStream();
  proto = new A4Protocol(in, out);
  proto.startRunning();

}

/**
 * closeSlaveConnection()
 */
private void closePort() {
  if (proto != null) {
    proto.stopRunning();
    proto = null;
  }
  if (out != null) {
    try {
      out.flush();
      out.close();
      out = null;
    } catch (IOException ignored) {
    }
  }
  if (in != null) {
    try {
      in.close();
      in = null;
    } catch (IOException ignored) {
    }
  }
  if (commConn != null) {
    try {
      commConn.close();
      commConn = null;
    } catch (IOException ignored) {
    }
  }
}

/**
 * setOut()
 *
 * @param pin
 * @param state
 */
public String setOut(int pin, int state) {
  if (pin == 0) {
    out2 = (state != 0) ? 1 : 0;
    this.interrupt();
    return "OK";
  } else {
    return "[ERROR] - Index out of bounds";
  }
}

/**
 * setLedOut()
 *
 * @param mode
 */
public void setLedOut(int mode) {
  log("setLedOut(" + mode + ")");
  led_out2 = mode;
}

/**
 * overrideLedOut()
 */
public void overrideLedOut(boolean on, int value) {
  led_out2_override = on;
  led_out2_override_value = value;
}

/**
 * overrideLedGsm()
 */
public void overrideLedGsm(boolean on, int value) {
  led_gsm_override = on;
  led_gsm_override_value = value;
}

/**
 * forceHwReset();
 */
public void forceHwReset() {
  bForceHwReset = true;
}

/**
 * sleep()
 */
public void sleep() {
  bForceSleep = true;
}

/**
 * getOut()
 *
 * @return 0 or 1
 */
public int getOut() {
  return out2;
}

public void reportOnceAndPause() {
  bDebugAutoReport = false;
  printReport();
}

public void resume(int value) {
  iDebugLineCount = LINES_TO_SKIP;
  bDebugAutoReport = true;
}

public void printReport() {
  log("out=" + proto.out2resp + " Vin=" + proto.adVIn + "mV Vbatt=" + proto.adVBatt + "mV Vcharge=" + proto.adVCharge + "mV "
    + "btnCnt=" + proto.btnCnt + " uptime=" + proto.upTime);

}

}
