/**
 * Console for testing/debugging over serial port
 */
package com.sea.gbgs5;

import com.cinterion.io.ATCommandFailedException;
import com.cinterion.io.InPort;
import com.cinterion.io.InPortListener;
import com.sea.log.Logger;
import com.sea.modem.SyncAtCommand;
import com.sea.utils.Utils;
import java.io.IOException;
import java.util.Vector;

/**
 *
 * @author vorisek
 */
public class ConsoleReporter extends Thread implements InPortListener {

// --------------------------------------------------
// Public Properties
// --------------------------------------------------
// --------------------------------------------------
// Private Constants
// --------------------------------------------------
// --------------------------------------------------
// Private Properties
// --------------------------------------------------
private static ConsoleReporter instance;
private boolean bRunning;
private SyncAtCommand atc;
//private SyncAtCommand atc;
public static final int iLogLevel = Logger.INFO;

private InPort inp;
private int lastPortValue;

private boolean bAuto;
private int iAutoMode;

// --------------------------------------------------
// Class Code
// --------------------------------------------------
public ConsoleReporter() {
  super();
  bAuto = false;
  iAutoMode = 0;
}

/**
 * getInstance
 */
public static ConsoleReporter getInstance() {
  if (instance == null) {
    instance = new ConsoleReporter();
  }
  return instance;
}

/**
 * startRunning
 */
public void startRunning() {
  bRunning = true;
  this.start();
}

/**
 * stopRunning
 */
public void stopRunning() {
  bRunning = false;
  this.interrupt();
}

/**
 * Debug printing
 */
protected static void log(String line) {
  log(line, Logger.INFO);
}

/**
 * Debug printing
 */
protected static void log(String line, int level) {
  if (iLogLevel >= level) {
    Logger.log("@Console", line);
  }
}

/**
 * Register an ATCommand for use with this singleton instance.
 *
 * @param aSyncAtCommand
 */
public void registerAtCommand(SyncAtCommand aSyncAtCommand) {
  atc = aSyncAtCommand;
}

/**
 * run
 */
public void run() {

  Vector pins = new Vector();
  pins.addElement("GPIO8"); // X2
  pins.addElement("GPIO7"); // X1
  try {
    inp = new InPort(pins);
    lastPortValue = inp.getValue();
    inp.addListener(this);
  } catch (IOException ex) {
    ex.printStackTrace();
  }

  //log("Thread started", Logger.ALWAYS);
  while (bRunning) {
    try {

      try {
        sleep(1000);
      } catch (InterruptedException ignored) {
      }

      if (bAuto) {
        printReport();
      }

      //} catch (InterruptedException ignored) {
    } catch (Exception e) {
      // An exception occured. Go the interrupted step again.
      log("[ EXCEPTION ] - '" + e.toString() + "'", Logger.ERROR);
      e.printStackTrace();

    }

  }

  /*
  // It is not nescessary to release InPort and it somtimes does problems when exiting midlet
  try {
    inp.release();
  } catch (IOException ignored) {
  }*/

  //log("Thread finished", Logger.ALWAYS);
}

void reportOnceAndPause() {
  bAuto = false;
  printReport();
}

void resume(int mode) {
  iAutoMode = mode;
  bAuto = true;
  this.interrupt();
}

public void portValueChanged(int portValue) {
  //log("inPortValueChanged() - value = " + Integer.toHexString(portValue) + " lastValue = " + lastPortValue);
  lastPortValue = portValue;
  this.interrupt();
}

/**
 * Return current ADC value
 *
 * 15:51:03.671: - at^sradc=1<#0D>
 * 15:51:03.703: + at^sradc=1 15:51:03.741: + ^SRADC: 1,1200 15:51:03.763: + OK
 *
 * @param src
 * @return
 */
private int getAdc1Value() {

  int result = -1;
  String resp, s;

  try {
    resp = atc.send("AT^SRADC=1\r");
    int pos1 = resp.indexOf("^SRADC:");
    int pos2 = resp.indexOf(":", pos1);
    int pos3 = resp.indexOf("\r", pos2);
    if ((pos1 >= 0) && (pos2 > pos1) && (pos3 > pos2)) {
      // Valid response
      s = resp.substring(pos2 + 1, pos3);
      Vector elements = Utils.splitComma(s);
      String value = (String) elements.elementAt(1);
      result = Integer.parseInt(value);
      //log("@Point A - capacity=" + capacity + ", used1=" + result);

    } else {
      // Something is wrong!
    }
  } catch (ATCommandFailedException ex) {
    ex.printStackTrace();
  } catch (NumberFormatException ignored) {
  }
  return result;
}

private void printReport() {

  if (Control.isDeviceGsmKlic()) {
    log("STATE - X1=" + ((lastPortValue >> 1) & 0x01) + ";X2=" + (lastPortValue & 0x01) + ";Y3=" + Slave.getInstance().getOut() + ";A4="
            + "?" + " ADC" + ";");
  } else if (Control.isDeviceGsmR2Ring() || Control.isDeviceGsmR2T()) {
    log("STATE - A1=" + getAdc1Value() + " ADC;X2=" + (lastPortValue & 0x01) + ";Y3=" + Slave.getInstance().getOut() + ";");
  } else if (Control.isDeviceGsmPress()) {
    log("STATE - A1=?" + " Pa" + ";X2=" + lastPortValue + ";Y3=" + Slave.getInstance().getOut() + ";A4="
            + "?" + " ADC" + ";");

  } else if (Control.isDeviceGsmR5MODBUS() || Control.isDeviceGsmBgs5()) {
    log("STATE - A1=?;Y2=" + Slave.getInstance().getOut() + ";X3=" + (lastPortValue & 0x01) + ";");
  } else if (Control.isDeviceGsmR5T()) {
    log("STATE - A1=" + getAdc1Value() + ";Y2=" + Slave.getInstance().getOut() + ";X3=" + (lastPortValue & 0x01) + ";");
  } else {
    log("STATE - X1=" + ((lastPortValue >> 1) & 0x01) + ";Y2=" + Slave.getInstance().getOut() + ";");

  }

}

}
