/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.sea.utils;

import java.util.Enumeration;
import java.util.Vector;

/**
 *
 * @author vorisek
 */
public class Utils {

/**
 * Convert MODBUS packet to string for printing
 *
 * @param src
 * @param offset
 * @param pos
 * @return
 */
public static String pckt2str(byte[] src, int offset, int len) {
  StringBuffer result = new StringBuffer();
  result.append("l=").append(len).append("| ");
  if (len < 40) {
    result.append(Utils.byteArrayToHexStringWithSpaces(src, offset, len));
  } else {
    result.append(Utils.byteArrayToHexStringWithSpaces(src, 0, 13));
    result.append(" ... ");
    result.append(Utils.byteArrayToHexStringWithSpaces(src, len - 4, 4));
  }
  return result.toString();
}

// for parseEventName()
public static class RecEvent {

public int type; // 0=SMS, 1=CALL
public int eid;
}

/**
 * isLetter
 *
 * @param c
 * @return true if 'c' is a letter (case does not matter)
 */
public static boolean isLetter(char c) {

  return (((c >= 'A') && (c <= 'Z')) || ((c >= 'a') && (c <= 'z')));
}

/**
 * Check if supplied string is valid phone number: '+420777777446' ---> true '*+420777777446' ---> true 'AA' ---> false '+420123456789'
 * --> false
 *
 * @param src String
 * @return boolean true is OK
 */
public static boolean isValidPhoneNumber(String src) {

  try {
    if (src == null) {
      return false;
    }
    src = src.trim();
    if (src.length() == 0) {
      return false;
    }
    if (src.equals("+420123456789")) {
      return false;
    }
    for (int i = 0; i < src.length(); i++) {
      if (((src.charAt(i) >= '0') && (src.charAt(i) <= '9')) || (src.charAt(i) == '#')
        || (src.charAt(i) == '*')) {
        // OK
      } else {
        if (src.charAt(i) == '+') {
          if (i == 0) {
            continue; // '+' at the beggining of the src is allowed
          } else if (i == 1) {
            if (src.charAt(i - 1) == '*') {
              continue;
            }
          }
        }
        return false;
      }
    }
  } catch (Exception e) {
    return false;
  }

  return true;
}

/**
 * Split source string into parts 
 "GENERAL MS4515DS5A002DP 0.262 -498 2.357 +498 Pa" -----> ("GENERAL", "MS4515DS5A002DP", "0.262",
 * "-498 ", "2.357", "+498", "+Pa") "+420777777446,+420777777450 +420777777451; +420777777452" -----> ("+420777777446",
 * "+420777777450", "+420777777451", "+420777777452")
 *
 * @param src
 * @return Vector
 */
public static Vector split(String src) {

  int i = 0;
  int len = src.length();
  char c;
  Vector result;
  boolean bInside = false;
  int iPosBegin = 0;

  result = new Vector();
  while (i < len) {
    c = src.charAt(i);
    if ((c == ' ') || (c == ';') || (c == ',')) {
      if (!bInside) {
        // Nothing yet
      } else {
        // A part has just ended
        result.addElement(src.substring(iPosBegin, i));
        bInside = false;
      }
    } else {
      if (!bInside) {
        // Start of a part
        bInside = true;
        iPosBegin = i;
      } else {
        // Still inside
      }
    }
    i++;
  }
  if (bInside) {
    // At the end add the reset of test
    result.addElement(src.substring(iPosBegin, i));
  }
  return result;
}

public static Vector splitComma(String src) {
  return splitNeedle(src, ',');
}

/**
 * Split source string into parts 
 * ""REC READ","+420777777446",,"14/01/08,15:04:28+04",145,32,0,0,"+420608005686",145,10"
 *  -----> ("REC READ", "+420777777446", "", "14/01/08,15:04:28+04", "145", "32", "0", "0", "+420608005686", "145", "10")
 *
 * @param src
 * @return Vector
 */
public static Vector splitNeedle(String src, char needle) {

  int i = 0;
  int len = src.length();
  char c;
  Vector result;
  boolean bInside = false;
  boolean bInsideString = false;
  int iPosBegin = 0;
  int iPosEnd = -1;

  result = new Vector();
  while (i < len) {
    c = src.charAt(i);
    if (c == '"') {
      // String begin/end
      if (!bInsideString) {
        // begin of the string
        bInsideString = true;
        bInside = true;
        iPosBegin = i + 1;
      } else {
        // end of the string
        bInsideString = false;
        iPosEnd = i;
      }
    } else if ((!bInsideString) && (c == needle)) {
      if (!bInside) {
        // Nothing yet, but I have to add empty element
        result.addElement("");
      } else {
        // A part has just ended
        if (iPosEnd == -1) {
          result.addElement(src.substring(iPosBegin, i).trim());
        } else {
          result.addElement(src.substring(iPosBegin, iPosEnd).trim());
        }
        iPosEnd = -1;
        bInside = false;
      }
    } else {
      if (!bInside) {
        // Start of a part
        bInside = true;
        iPosBegin = i;
      } else {
        // Still inside
      }
    }
    i++;
  }
  if (bInside) {
    // At the end add the reset of test
    if (iPosEnd == -1) {
      result.addElement(src.substring(iPosBegin, i).trim());
    } else {
      result.addElement(src.substring(iPosBegin, iPosEnd).trim());
    }
  }
  return result;
}

/**
 * Join array elements with a string
 *
 * @param glue
 * @param pieces Vector of Strings
 * @return
 */
public static String implode(String glue, Vector pieces) {

  String result;
  String s;
  boolean first;

  if (glue == null) {
    glue = "";
  }
  if (pieces == null) {
    return "";
  }

  result = "";
  first = true;
  for (Enumeration e = pieces.elements(); e.hasMoreElements();) {
    s = (String) e.nextElement();
    if (first) {
      result += s;
    } else {
      result += glue + s;
    }
    first = false;
  }
  return result;
}

/**
 * hexStringToByteArray()
 *
 * @param src, example 030010
 * @return byte[], example 0x03, 0x00, 0x10
 */
public static byte[] hexStringToByteArray(String src) {
  int len = src.length();
  return hexStringToByteArray(src, 0, len);
}

/**
 * hexStringToByteArray()
 *
 * @param src, example 030010
 * @return byte[], example 0x03, 0x00, 0x10
 */
public static byte[] hexStringToByteArray(String src, int offset, int len) {
  byte[] data = new byte[len / 2];
  for (int i = 0; i < len; i += 2) {
    data[i / 2] = (byte) ((Character.digit(src.charAt(i), 16) << 4) + Character.digit(src.charAt(i + 1), 16));
  }
  return data;
}

/**
 * byteArrayToHexString()
 *
 * @param src
 * @return
 */
static final String HEXES = "0123456789ABCDEF";

public static String byteArrayToHexString(byte[] src) {
  int len = src.length;
  return byteArrayToHexString(src, 0, len);

}

public static String byteArrayToHexString(byte[] src, int offset, int len) {
  StringBuffer result = new StringBuffer(2 * len);
  byte b;
  for (int i = offset; i < offset + len; i++) {
    b = src[i];
    result.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt((b & 0x0F)));
  }
  return result.toString();
}

public static StringBuffer byteArrayToHexStringWithSpaces(byte[] src, int offset, int len) {
  StringBuffer result = new StringBuffer(3 * len);
  byte b;
  boolean first = false;
  for (int i = offset; i < offset + len; i++) {
    if (first) {
      first = false;
    } else {
      result.append(" ");
    }
    b = src[i];
    result.append(Utils.HEXES.charAt((b & 0xF0) >> 4)).append(Utils.HEXES.charAt((b & 0x0F)));
  }
  return result;
}

/**
 * 0xF2 --> "F2", 0x05 --> "05
 *
 * Uses the lowest byte or 'value' only
 *
 * @param value
 * @return
 */
public static String byteToHexString(int value) {
  StringBuffer result = new StringBuffer(2);
  result.append(Utils.HEXES.charAt((value >> 4) & 0x0F)).append(Utils.HEXES.charAt((value & 0x0F)));
  return result.toString();
}

/**
 * clearBegginingOfString()
 *
 * @param src
 * @return
 */
public static String clearBegginingOfString(String src) {

  boolean bAsciiFound = false;
  int i = 0;
  while (i < src.length()) {
    if ((src.charAt(i) >= '!') && (src.charAt(i) <= '~')) {
      bAsciiFound = true;
      break; // while ()
    }
    i++;
  }
  if ((i > 0) && bAsciiFound) {
    return src.substring(i);
  } else {
    return src;
  }
}

/**
 * (int) 2 --> "02" (int) 15 --> "15"
 *
 * @param year
 * @return
 */
public static String to2charStr(int value) {

  String result;

  result = Integer.toString(value);
  if (result.length() < 2) {
    result = "0" + result;
  }

  return result;
}

/**
 * formatDouble()
 *
 * @param fixed 0..10
 */
public static String formatDouble(double value, int fixed) {

  double pow = 1;
  for (int i = 1; i <= fixed; i++) {
    pow *= 10.0;
  }

  value = value * pow;
  value = Math.floor(value);
  value = value / pow;

  return Double.toString(value);

}

/**
 * Return string of size "count" filled with character "c"
 *
 * @param c char
 * @param count int
 * @return String
 */
public static String fillChar(char c, int count) {
  char result[] = new char[count];
  for (int i = 0; i < result.length; i++) {
    result[i] = c;
  }
  return new String(result);
}

/**
 * formatHHMM()
 *
 * @param src [ms]
 * @return "1:05"
 */
public static String formatHHMM(long src) {
  double f, fh, fm;
  int hrs, min;
  String sHrs, sMin;

  f = src;
  f = f / (1000 * 60 * 60);  // [hrs]
  fh = Math.floor(f);
  fm = f - fh;
  hrs = (int) fh;
  min = (int) (fm * 60);

  sHrs = Integer.toString(hrs);
  sMin = Integer.toString(min);

  if (sMin.length() == 1) {
    sMin = '0' + sMin;
  }

  return sHrs + ":" + sMin;

}

/**
 * Byte swap a single int value.
 *
 * @param value Value to byte swap.
 * @return Byte swapped representation.
 */
public static int swap(int value) {
  int b1 = (value >> 0) & 0xff;
  int b2 = (value >> 8) & 0xff;
  int b3 = (value >> 16) & 0xff;
  int b4 = (value >> 24) & 0xff;

  return b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0;
}
}
