/*
 * Object to hide changes in System.currentTimeMillis() during changes of the RTC. 
 * From BGS5 on System.currentTimeMillis() is changed back or forward according to 
 * RTC sent from GSM provider
 */
package com.sea.utils;

import com.sea.log.Logger;

/**
 *
 * @author Vorisek
 */
public class Timed {

private static long offset = 0;
private static long lastTimeMillis = 0;
private static long lastResult = 0;

/**
 * Simulate System.currentTimeMillis() but do not allow backward jumps or too far forward jumps
 *
 * @return currentTimeMillis() [ms]
 */
public static long currentTimeMillis() {
  long now = System.currentTimeMillis();
  long delta = now - lastTimeMillis;
  if ((now < 0) || (delta >= 20 * 1000)) {
    // Move backward || Move too far forward
    Logger.log("@Timed", "Time shift detected, last=" + lastTimeMillis + " current=" + now);
    long wantReturn = lastResult + 1;
    offset = wantReturn - now;
  }

  lastTimeMillis = now;
  lastResult = now + offset;
  return lastResult;
}

/**
 * Tests whether specicied timeout is over
 *
 * @param startTime [ms]
 * @param timeout [ms]
 * @return
 */
public static boolean ist(long startTime, long timeout) {
  return (Timed.currentTimeMillis() - startTime) > timeout;
}
}
