/*
 * Return lines from a String
 */
package com.sea.utils;

/**
 *
 * @author vorisek
 */
public class LineReader {

protected String sSource;
protected int iPos;

/**
 * Constructor
 */
public LineReader(String s) {
  sSource = s;
  if (sSource == null) {
    sSource = "";
  }
  iPos = 0;
//  System.out.println("@LineReader: Constructor, sSource="+sSource);
}

/**
 * Return a line from source
 * 
 * @return String with one line or null if no other line is available
 */
public String getLine() {

  int i;
  String sResult;

  // Is anythin left?
  if (iPos >= sSource.length()) {
    return null;
  }

  // Look for nearest \n
  i = sSource.indexOf('\n', iPos);
  if (i == -1) {
    // no more lines, but text is available
    iPos = sSource.length();
    sResult = sSource.trim();
  } else {
    // Return one line and move index after this line
    sResult = sSource.substring(iPos, i);
    iPos = i + 1;
  }
  return sResult;
}

}
