/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.sea.log;

/**
 *
 * @author vorisek
 */
public class Logger {

/**
 * No events will be logged. 
 */
public static final int OFF = 0;
/**
 * An always logged event
 */
public static final int ALWAYS = 0;
/**
 * A severe error that will prevent the application from continuing. 
 */
public static final int FATAL = 1;
/**
 * An error in the application, possibly recoverable.
 */
public static final int ERROR = 2;
/**
 * An event that might possible lead to an error.
 */
public static final int WARN = 3;
/**
 * An event for informational purposes.
 */
public static final int INFO = 4;
/**
 * A general debugging event.
 */
public static final int DEBUG = 5;
/**
 * A fine-grained debug message, typically capturing the flow through the application.
 */
public static final int TRACE = 6;
// 
/**
 * All events should be logged. 
 */
public static final int ALL = Integer.MAX_VALUE;

/**
 * log()
 * 
 * @param prefix
 * @param line
 * @param level 
 */
public static void log(String prefix, String line) {
    if (line != null) {
        System.out.println(prefix + ": " + line);
    }
}

}
