package com.sea.gbgs5;

import javax.microedition.midlet.MIDlet;

/**
 * GBGS5 Test Software
 *
 *
 * History
 * 2015-09-03 GSM-PRESS, version 1.01
 * a) Project foundation, import from GSM-PRESS, version 1.02
 * 2015-12-09 GBGS5TEST, version 1.03
 * a) Name changed to GBGS5TEST
 * 2017-01-16 GBGS5TEST, version 1.06
 * a) Enable power supply for GBGS5M
 * 2017-01-19 GBGS5TEST, version 1.07
 * a) +Support for SLEEP (=new command for Slave)
 * 2018-04-17 GBGS5TEST, version 1.08
 * a) +Support for GSM-R5-MODBUS
 * 2018-04-17 GBGS5TEST, version 1.09
 * a) +Support for GSM-R5-T
 * 2018-06-04 GBGS5TEST, version 1.10
 * a) ^Recompiled with support for BGS5 v02.000
 * 2018-06-15 GBGS5TEST, version 1.11
 * a) #Fix: GSM-BGS5-xxx reports state (d1) in wrong format. New format is 
 * 2018-06-18 GBGS5TEST, version 1.12
 * a) #Fix: GSM-BGS5-xxx and GSM-MODBUS-xxx doesn't switch on power for RS485 or RS232 transiever
 *
 *
 */
/**
 * TODOLIST
 */

/*
 Legend:

 * -> Security Fix
 # -> Bug Fix
 $ -> Language fix or change
 + -> Addition
 ^ -> Change
 - -> Removed
 ! -> Note
 */
public class Main extends MIDlet {

// --------------------------------------------------
// Public Constants
// --------------------------------------------------  
// --------------------------------------------------
// Public Properties
// --------------------------------------------------
// --------------------------------------------------
// Public Constants
// --------------------------------------------------  
public static final String PRODUCT_NAME = "GBGS5TEST";
public static final String PRODUCT_NUMBER = "C5-88-D9";
public static final String PRODUCT_VERSION = "1.12";

// --------------------------------------------------
// Public Properties
// --------------------------------------------------
// --------------------------------------------------
// Private Constants
// --------------------------------------------------
private static Main instance = null;
// --------------------------------------------------
// Private Properties
// --------------------------------------------------
private static Control cntrl;

/**
 * startApp()
 */
public void startApp() {

  instance = this;

  System.out.println();
  System.out.println("***********************************");
  System.out.println("*           Starting up           *");
  System.out.println("***********************************");
  System.out.println();

  cntrl = Control.getInstance();
  cntrl.startRunning();

}

public void pauseApp() {
}

/**
 * destroyApp
 *
 * @param unconditional boolean
 */
public void destroyApp(boolean unconditional) {

  String _prefix = "@Main: ";
  System.out.println(_prefix + "------------------------------------------------------------------");
  System.out.println(_prefix + "--          Shutting down                                       --");
  System.out.println(_prefix + "------------------------------------------------------------------");
  if (cntrl != null) {
    try {
      cntrl.stopRunning();
      cntrl.join();
      cntrl = null;
    } catch (InterruptedException ex) {
      cntrl = null;
      ex.printStackTrace();
    }
  }

  System.out.println("@Main: APPLICATION HALTED!");
  notifyDestroyed();
}

/**
 * getInstance()
 */
public static Main getInstance() {
  return instance;
}

}
