/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.sea.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 *
 * @author vorisek
 */
public class PrimitiveDataInputStream extends DataInputStream {

protected boolean littleEndian;

public PrimitiveDataInputStream(InputStream in) {
  super(in);
}

public PrimitiveDataInputStream(InputStream in, boolean alittleEndian) {
  this(in);
  littleEndian = alittleEndian;
}

public int readU8() throws IOException {
  return read();
}

public int readU16() throws IOException {
  int value;
  if (littleEndian) {
    value = read();
    value |= read() << 8;
  } else {
    value = read() << 8;
    value |= read();
  }
  return value;
}

public int readU24() throws IOException {
  int value;
  if (littleEndian) {
    value = read();
    value |= read() << 8;
    value |= read() << 16;
  } else {
    value = read() << 16;
    value |= read() << 8;
    value |= read();
  }
  return value;
}
public long readU32() throws IOException {
  int value;
  if (littleEndian) {
    value = read();
    value |= read() << 8;
    value |= read() << 16;
    value |= read() << 24;
  } else {
    value = read() << 24;
    value |= read() << 16;
    value |= read() << 8;
    value |= read();
  }
  return value;
}

}
