/*
 * Device configuration
 */
package com.sea.gbgs5;

//import com.sea.config.*;
import com.sea.log.Logger;
import com.sea.utils.*;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

/**
 *
 * @author vorisek
 */
public class Cfg {

// --------------------------------------------------
// Public configuration
// --------------------------------------------------
//public static CfgGeneral general;
//public static CfgGprs gprs;

public static String modemImei;
public static final String DEFAULT_SERIAL_NUMBER = "GF516001";
public static String SERIAL_NUMBER = DEFAULT_SERIAL_NUMBER; // real S/N will come from 'sn.txt'
public static String PRODUCT_NAME = "GSM-R5";

// --------------------------------------------------
// Public Constants
// --------------------------------------------------
public static final int VARIANT_UNK = -1;
public static final int VARIANT_GSM_R5_ZAS = 1;
public static final int VARIANT_GSM_R5_ZAS_2A = 2;
public static final int VARIANT_GSM_R5_ZAS_2IN = 3;
public static final int VARIANT_GSM_R5_ZAS_5IN = 4;
public static final int VARIANT_GSM_R5_ZAS_3OUT = 5;
public static final int VARIANT_GSM_R5_RING = 6;
public static final int VARIANT_GSM_R5_OHRADNIK = 7;
public static final int VARIANT_GSM_R5_T = 8;
public static final int VARIANT_GSM_SP11B = 9;
public static final int VARIANT_GSM_MODBUS = 10;
public static final int VARIANT_GSM_BGS5 = 11;

// --------------------------------------------------
// Public Properties
// --------------------------------------------------
public static int variant = VARIANT_UNK; // Cfg.VARIANT_xxx

// --------------------------------------------------
// Private Properties
// --------------------------------------------------
public static int iLogLevel = Logger.INFO;
private static Vector listeners; // Vector of CfgListeners

// --------------------------------------------------
// Private Constants
// --------------------------------------------------
private static final String FILENAME_SERIAL_NUMBER = "file:///A:/sn.txt";
private static final String FILENAME_CFG_ROOT = "file:///A:/cfg";

// --------------------------------------------------
// Class Code
// --------------------------------------------------
static void init() {
  System.out.println("@Cfg.static init");

  checkAndCreateCfgRoot();

  // Configuration
  //general = new CfgGeneral();
  //general.read();
  //gprs = new CfgGprs();
  //gprs.read();

  modemImei = "?????????????????????????";

  listeners = new Vector();
}

/**
 * Debug printing
 */
private static void log(String line) {
  log(line, Logger.INFO);
}

/**
 * Debug printing
 */
private static void log(String line, int level) {
  if (iLogLevel >= level) {
    Logger.log("@Cfg", line);
  }

}

/**
 * Print current configuration
 */
public static void printConfiguration() {
  log("Current configuration:");
  //log("general: " + general.toString());

}

public static void addListener(CfgListener item) {
  listeners.addElement(item);
}

public static void removeListener(CfgListener item) {
  listeners.removeElement(item);
}

/**
 * Notify all listeners about configuration change
 */
public static void changed() {
  for (int i = 0; i < listeners.size(); i++) {
    ((CfgListener) listeners.elementAt(i)).cfgChanged();
  }

}


/**
 * Reset configuration of the device
 */
public static void factory() throws IOException {
  //Cfg.general.setDefault();
  //Cfg.general.write();
}


private static void checkAndCreateCfgRoot() {
  FileConnection fconn = null;
  try {
    fconn = (FileConnection) Connector.open(FILENAME_CFG_ROOT);
    if (!fconn.isDirectory()) {
      fconn.mkdir();
    }

  } catch (IOException e) {
    log("[EXCEPTION] - " + e.getMessage(), Logger.ERROR);
  } finally {
    try {
      if (null != fconn) {
        fconn.close();
      }
    } catch (IOException e) {
      System.out.println(e.getMessage());
    }
  }
}

/**
 * detectSerialNumber()
 */
public static void detectSerialNumber() {

  String sText;
  LineReader lReader;
  String s;
  String sResult = "";

  // Read whole file into a String
  sText = FileUtils.readTextFile(FILENAME_SERIAL_NUMBER);
  lReader = new LineReader(sText);
  // Get the first line
  s = lReader.getLine();
  if (s != null) {
    if (s.length() >= 3) {
      if (s.charAt(0) == 'G') {
        sResult = s.trim();
      }
    }
  }

  // Default serial number for exceptional cases (because SeaConfigurator will get mad without serial number)
  if (sResult.length() == 0) {
    sResult = DEFAULT_SERIAL_NUMBER;
  }
  SERIAL_NUMBER = sResult;

  // Detect enum from text serial number
  if (SERIAL_NUMBER.startsWith("GF0")) {
    Cfg.variant = VARIANT_GSM_R5_ZAS_3OUT;
    Cfg.PRODUCT_NAME = "GSM-R5-ZAS-3OUT";
  } else if (SERIAL_NUMBER.startsWith("GF1")) {
    Cfg.variant = VARIANT_GSM_R5_ZAS_2A;
    Cfg.PRODUCT_NAME = "GSM-R5-ZAS-2A";
  } else if (SERIAL_NUMBER.startsWith("GF2")) {
    Cfg.variant = VARIANT_GSM_R5_ZAS_2IN;
    Cfg.PRODUCT_NAME = "GSM-R5-ZAS-2IN";
  } else if (SERIAL_NUMBER.startsWith("GF3")) {
    Cfg.variant = VARIANT_GSM_R5_ZAS_5IN;
    Cfg.PRODUCT_NAME = "GSM-R5-ZAS-5IN";
  } else if (SERIAL_NUMBER.startsWith("GF4")) {
    Cfg.variant = VARIANT_GSM_R5_T;
    Cfg.PRODUCT_NAME = "GSM-R5-T";
  } else if (SERIAL_NUMBER.startsWith("GD3")) {
    Cfg.variant = VARIANT_GSM_R5_RING;
    Cfg.PRODUCT_NAME = "GSM-RING";
  } else if (SERIAL_NUMBER.startsWith("GE4")) {
    Cfg.variant = VARIANT_GSM_R5_OHRADNIK;
    Cfg.PRODUCT_NAME = "GSM-OHRADNIK";
  } else if (SERIAL_NUMBER.startsWith("GF6")) {
    Cfg.variant = VARIANT_GSM_SP11B;
    Cfg.PRODUCT_NAME = "GSM-SP11B";
  } else if (SERIAL_NUMBER.startsWith("GF8")) {
    Cfg.variant = VARIANT_GSM_MODBUS;
    Cfg.PRODUCT_NAME = "GSM-MODBUS";
  } else if (SERIAL_NUMBER.startsWith("GD5")) {
    Cfg.variant = VARIANT_GSM_BGS5;
    Cfg.PRODUCT_NAME = "GSM-BGS5";
  } else { // if (SERIAL_NUMBER.startsWith("GF5")){
    Cfg.variant = VARIANT_GSM_R5_ZAS;
    Cfg.PRODUCT_NAME = "GSM-R5-ZAS";
  }

}


}
