package com.sea.utils;

import java.util.Vector;

/**
 * <p>Title: GSMRELE2</p>
 *
 * <p>Description: Thread safe queue (solving Producer-Consumer problem)</p>
 *
 * <p>Copyright: Copyright (c) 2006</p>
 *
 * <p>Company: SEA</p>
 *
 * @author Vorisek
 * @version 1.0
 */
public class SafeQueue {

    // --------------------------------------------------
    // Private Constants
    // --------------------------------------------------

    private final int MAX_ITEMS = 100;

    // --------------------------------------------------
    // Private Properties
    // --------------------------------------------------

    private Vector buffer = null;
    private int intElements = 0;
    private int intSpaces = MAX_ITEMS;

    // Synchronization
    private Object conveyD = null;
    private Object conveyF = null;


    public SafeQueue() {
        super();

        buffer = new Vector();
        intElements = 0;
        intSpaces = MAX_ITEMS;

        conveyD = new Object();
        conveyF = new Object();
    }

    /**
     * Deposit item in queue
     */
    public void deposit(Object item) throws InterruptedException {
        synchronized (conveyD) {
            while (intSpaces == 0) {
                conveyD.wait();
            }

            intSpaces--;
            buffer.addElement(item);

        }
        synchronized (conveyF) {
            intElements++;
            conveyF.notifyAll();
        }
    }

    /**
     * Fetch item from queue. Wait until an item is ready.
     */
    public Object fetch() throws InterruptedException {
        Object result;
        synchronized (conveyF) {
            while (intElements == 0) {
                conveyF.wait();
            }

            intElements--;
            result = buffer.firstElement();
            buffer.removeElementAt(0);
        }
        synchronized (conveyD) {
            intSpaces++;
            conveyD.notifyAll();
        }

        return result;
    }

    /**
     * Returns length of the queue
     */
    public int length() {
        synchronized (conveyF) {
            return intElements;
        }
    }

    /**
     * toString
     */
    public String toString() {
        synchronized (conveyF) {
            synchronized (conveyD) {
                return "Queue: length=" + intElements + ", spaces=" + intSpaces ;
            }
        }
    }


}
