/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.sea.io;

import com.sea.utils.Crc8;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 *
 * @author vorisek
 */
public class A4DataOutputStream extends DataOutputStream {

// Frames
private static final int PROTO_STX = 0xA4;
private static final int PROTO_ETX = 0xA3;

protected int crc8;


public A4DataOutputStream(OutputStream out) {
  super(out);
}


/**
 * Begin of a frame
 *
 * @param value
 * @throws IOException
 */
public void begin(int cmd) throws IOException {
  crc8 = 0xFF;
  write(PROTO_STX);
  writeU8(cmd);
}


public void end() throws IOException {
  writeU8(crc8);
  write(PROTO_ETX);
}


/**
 * Write lower 8 bits (0.-7.) to OutputStream
 *
 * @param value
 * @throws IOException
 */
public void writeU8(int value) throws IOException {
  int bh, bl;

  Crc8.update(crc8, value);
  bh = (value >> 4) & 0x0F;
  bh += (bh <= 9) ? 48 : 55;  // to HEX
  bl = value & 0x0F;
  bl += (bl <= 9) ? 48 : 55;
  write(bh);
  write(bl);
}

}
