/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.sea.gbgs5;

import com.sea.io.*;
import com.sea.log.Logger;
import com.sea.utils.*;
import java.io.*;

/**
 *
 * @author vorisek
 */
public class A4Protocol extends Thread {

// --------------------------------------------------
// Public Constants
// --------------------------------------------------
public final int UNKNOWN_AD_VALUE = 0x80000000;

// --------------------------------------------------
// Public Properties
// --------------------------------------------------
public int revisionH = -1;
public int revisionL = -1;
public int out2resp = 0;
public int adVIn = UNKNOWN_AD_VALUE; // [mV]
public int adVBatt = UNKNOWN_AD_VALUE; // [mV]
public int adVCharge = UNKNOWN_AD_VALUE; // [mV]
public int adPressureAdc = UNKNOWN_AD_VALUE; // [ADC]
public int btnCnt = -1; // -1=never communication, 0=never pressed, 1, 2, ... 254, 255, 1, 2, ...
public long upTime = -1;

// --------------------------------------------------
// Private Constants
// --------------------------------------------------
private final static int MAX_PACKET_LEN = 260;  // 256 should be enough, but just to be sure

// Commands
private static final int CMD_IO = 0x10;
private static final int CMD_ADC = 0x14;
private static final int CMD_MODEM_RESTART = 0x31;
private static final int CMD_MODEM_SLEEP = 0x32;
private static final int RESPONSE = 0x80;

// Frames
private static final int PROTO_STX = 0xA4;
private static final int PROTO_ETX = 0xA3;

// --------------------------------------------------
// Machine states
// --------------------------------------------------
// Private Properties
// --------------------------------------------------
protected boolean running = false;
public int iLogLevel = Logger.DEBUG;
protected InputStream in = null;
protected OutputStream out = null;
protected int inTimeout; // [ms]

// Receiver thread
protected final byte[] inPacket = new byte[MAX_PACKET_LEN]; // Buffer for input packet (whole & valid)
protected int inLen;
protected boolean isPacketReceived;

// Query
protected final VorByteArrayOutputStream outQuery = new VorByteArrayOutputStream(MAX_PACKET_LEN);
protected final A4DataOutputStream outData = new A4DataOutputStream(outQuery);

// Response
protected byte[] response = new byte[MAX_PACKET_LEN];
protected final VorByteArrayInputStream inResponse = new VorByteArrayInputStream(response);
protected final PrimitiveDataInputStream inData = new PrimitiveDataInputStream(inResponse);

/**
 * Constructor
 */
public A4Protocol(InputStream sin, OutputStream sout) {

  in = sin;
  out = sout;
  inTimeout = 1000;

}

/**
 * Used to start the thread
 */
public void startRunning() {
  // Reset watchdog
  running = true;
  start();
}

/**
 * Used to kill the thread
 */
public void stopRunning() {
  running = false;
}

/**
 * Debug printing
 */
private void log(String line) {
  log(line, Logger.INFO);
}

/**
 * Debug printing
 */
private void log(String line, int level) {
  if (iLogLevel >= level) {
    Logger.log("@A4", line);
  }

}

/**
 * Set input timeout
 *
 * @param inTimeout [ms]
 */
public void setInTimeout(int inTimeout) {
  this.inTimeout = inTimeout;
}

/**
 * Receive loop
 */
public void run() {

  byte[] inTemp = new byte[260]; // Temporary buffer for input data
  int pos = 0;
  int crc = 0xFF;
  int b, bl, bh;
  boolean insideOfPacket;

  insideOfPacket = false;
  while (running) {
    try {

      b = in.read();
      if (b == -1) {
        break; // EOF
      }
      if (b < 0) {
        b += 256;
      }

      if (b == PROTO_STX) {
        // Begin of packet 
        insideOfPacket = true;
        pos = 0;

      } else if (insideOfPacket && (b == PROTO_ETX)) {
        // End of packet
        int j = 0;
        inLen = 0;
        for (int i = 0; i < (pos / 2); i++) {
          bh = inTemp[j++];
          bh -= (bh <= 0x39) ? 0x30 : 55;
          bl = inTemp[j++];
          bl -= (bl <= 0x39) ? 0x30 : 55;
          b = (bh << 4) | bl;
          inPacket[i] = (byte) b;
          inLen++;
        }
        crc = Crc8.countCrc8(inPacket, 0, inLen);
        if (crc == 0x00) {
          synchronized (inPacket) {
            //#if DEBUG_MESSAGES == 1
//#             log("worker> Received packet - " + Utils.pckt2str(inPacket, 0, inLen), Logger.DEBUG);
            //#endif
            isPacketReceived = true;
            inPacket.notify(); // Let transact() notify about new packet
          }

        } else {
          log("[ERROR] - Received packet with invalid CRC - raw: " + Utils.pckt2str(inTemp, 0, pos), Logger.ERROR);
          log("[ERROR] - Received packet with invalid CRC - decoded: " + Utils.pckt2str(inPacket, 0, inLen), Logger.ERROR);
        }

      } else if (insideOfPacket) {
        inTemp[pos++] = (byte) b;
        if (pos >= inTemp.length) { // Check for max. length
          insideOfPacket = false;
        }
      }

    } catch (Exception e) {
      // No exception can stop this thread
      try {
        sleep(100); // Pri chybe pockame, aby se nevytizil stroj, kdyby se chyba opakovala
      } catch (InterruptedException ignored) {
      }
    } // try  }

  }

  log("Thread finished.");

}

/**
 * Provede jednu transakci: tedy odeslani packetu a prijem odpovedi. Blokujici funkce Pouziva staticke promenne tridy: outPacket,
 * outIndex, inPacket, inIndex! Odesle packet z outPacket o delce outPacket Odpoved ulozi do inPacket a delku (bez STX a ETX) do
 * inIndex a
 *
 * @return int Vysledek: bud RESULT_OK, RESULT_ERR_xxx
 */
//public synchronized byte[] transact(byte[] rBufferOut, int offset, int len) throws IOException, InterruptedException {
public synchronized void transact(VorByteArrayOutputStream os, VorByteArrayInputStream is) throws IOException, InterruptedException {

  // Send prepared packet
  isPacketReceived = false;
  //#if DEBUG_MESSAGES == 1
//#   log("transact> sending packet: " + os.toString(), Logger.DEBUG);
  //#endif
  out.write(os.getByteArray(), 0, os.getCount());

  // Wait for receiver thread to finish the job and receive response (or timeout)
  synchronized (inPacket) {
    inPacket.wait(inTimeout);
    if (isPacketReceived) {
      // valid packet
      inResponse.copyFrom(inPacket, 0, inLen);
    } else {
      // timeout
      //#if DEBUG_MESSAGES == 1
//#       log("transact> timeout", Logger.DEBUG);
      //#endif
      throw new TimeoutException("Timeout");
    }
  }
}

/**
 *
 *
 * @param out2
 * @param led_out2
 * @param led_gsm
 * @param rs485baud
 * @param rs485set
 */
void io(int out2, int led_out2, int led_gsm, int rs485baud, int rs485set) throws Exception {

  synchronized (outQuery) {

    int cmd;

    outQuery.reset();
    outData.begin(CMD_IO);  // outData writes into outQuery
    outData.writeU8(out2);
    outData.writeU8(led_out2);
    outData.writeU8(led_gsm);
    outData.writeU8(rs485baud);
    outData.writeU8(rs485set);
    outData.end();

    transact(outQuery, inResponse);

    cmd = inData.readU8();
    if (cmd == (CMD_IO | RESPONSE)) {
      revisionH = inData.readU8();
      revisionL = inData.readU8();
      out2resp = inData.readU8();
      adVIn = inData.readU16();
      adVBatt = inData.readU16();
      adVCharge = inData.readU16();
      btnCnt = inData.readU8();
      upTime = inData.readU32();
    }

  }

}

/**
 * Read ADC values
 */
void adc() throws IOException, InterruptedException {

  synchronized (outQuery) {

    int cmd;

    outQuery.reset();
    outData.begin(CMD_ADC);  // outData writes into outQuery
    outData.writeU8(0x00); // ADC configuration for P0.3 - doesn't have any efect here
    outData.writeU8(0x08); // 0000 1000  P0.0=open-collector, P0.3=open-collector, sw i2c=2xsdp611,  button=disabled
   
    outData.end();

    transact(outQuery, inResponse);

    cmd = inData.readU8();
    if (cmd == (CMD_ADC | RESPONSE)) {
      adVIn = inData.readU16();
      adVBatt = inData.readU16();
      adVCharge = inData.readU16();
      adPressureAdc = inData.readU16();
    }
  }

}

/**
 * Restart everythink
 */
void restart() throws IOException, InterruptedException {
  
  synchronized (outQuery) {

    int cmd;

    outQuery.reset();
    outData.begin(CMD_MODEM_RESTART);  // outData writes into outQuery
    outData.writeU8(1);
    outData.end();

    transact(outQuery, inResponse);

    cmd = inData.readU8();
    if (cmd == (CMD_MODEM_RESTART | RESPONSE)) {
    }
  }
}

/**
 * Go to sleep mode (=GSM modem is powered off until L->H on main power occurs)
 */
void sleep() throws IOException, InterruptedException {
  
  synchronized (outQuery) {

    int cmd;

    outQuery.reset();
    outData.begin(CMD_MODEM_SLEEP);  // outData writes into outQuery
    outData.writeU8(0x01);            // 0x01 = ignore when powered on
    outData.end();

    transact(outQuery, inResponse);

    cmd = inData.readU8();
    if (cmd == (CMD_MODEM_SLEEP | RESPONSE)) {
    }
  }
}


}
