 /*
 * Copyright (C) Sea s.r.o. 2004. All Rights reserved.
 *
 * Thread safa variant of ATCommand
 *
 */
package com.sea.modem;

import com.cinterion.io.ATCommand;
import com.cinterion.io.ATCommandFailedException;

/**
 * <p>
 * Title: SyncAtCommand</p>
 * <p>
 * Description: Extends ATCommand and presents user with a synchronized send method to make ATCommand use Thread Safe.</p>
 * <p>
 * Company: Siemens</p>
 */
public class SyncAtCommand extends ATCommand {

private String name = "@at";

public SyncAtCommand(boolean csdSupport, String name) throws ATCommandFailedException {
  super(csdSupport);
  this.name = "@" + name;
}

public synchronized String send(String ATCmd) throws ATCommandFailedException {
  com.sea.log.Logger.log(name, "q=" + ATCmd);
  String response = super.send(ATCmd);
  com.sea.log.Logger.log(name, "r=" + response);
  return response;
}
}
