/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.sea.io;

import java.io.ByteArrayInputStream;
import com.sea.utils.*;

/**
 *
 * @author Vorisek
 */
public class VorByteArrayInputStream extends ByteArrayInputStream {

/**
 * Creates a ByteArrayInputStream so that it uses buf as its buffer array. The buffer array is not copied. The initial value of pos is 0 and the initial value of count is the length of buf.
 *
 * @param buf the input buffer.
 */
public VorByteArrayInputStream(byte[] buf) {
  super(buf);
}

public VorByteArrayInputStream(byte[] buf, int offset, int length) {
  super(buf, offset, length);
}


/**
 * Copy data from {@code src} to internal buffer and restart the stream
 *
 * @param src
 * @param offset
 * @param len
 */
public void copyFrom(byte[] src, int offset, int len) {
  System.arraycopy(src, offset, buf, 0, len);
  count = len;
  mark = pos = 0;
}

/**
 * Returns a string representation of the object. 
 * 
 * @return 
 */
public String toString() {
  return Utils.pckt2str(buf, 0, count);

}

}
