/*
 * Decompiled with CFR 0.152.
 */
package com.sea.utils;

import java.util.Enumeration;
import java.util.Vector;

public class Utils {
    static final String HEXES = "0123456789ABCDEF";

    public static String pckt2str(byte[] src, int offset, int len) {
        StringBuffer result = new StringBuffer();
        result.append("l=").append(len).append("| ");
        if (len < 40) {
            result.append((Object)Utils.byteArrayToHexStringWithSpaces(src, offset, len));
        } else {
            result.append((Object)Utils.byteArrayToHexStringWithSpaces(src, 0, 13));
            result.append(" ... ");
            result.append((Object)Utils.byteArrayToHexStringWithSpaces(src, len - 4, 4));
        }
        return result.toString();
    }

    public static boolean isLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isValidPhoneNumber(String src) {
        try {
            if (src == null) {
                return false;
            }
            if ((src = src.trim()).length() == 0) {
                return false;
            }
            if (src.equals("+420123456789")) {
                return false;
            }
            for (int i = 0; i < src.length(); ++i) {
                if (src.charAt(i) >= '0' && src.charAt(i) <= '9' || src.charAt(i) == '#' || src.charAt(i) == '*' || src.charAt(i) == '+' && (i == 0 || i == 1 && src.charAt(i - 1) == '*')) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Vector split(String src) {
        int i;
        int len = src.length();
        boolean bInside = false;
        int iPosBegin = 0;
        Vector<String> result = new Vector<String>();
        for (i = 0; i < len; ++i) {
            char c = src.charAt(i);
            if (c == ' ' || c == ';' || c == ',') {
                if (!bInside) continue;
                result.addElement(src.substring(iPosBegin, i));
                bInside = false;
                continue;
            }
            if (bInside) continue;
            bInside = true;
            iPosBegin = i;
        }
        if (bInside) {
            result.addElement(src.substring(iPosBegin, i));
        }
        return result;
    }

    public static Vector splitComma(String src) {
        return Utils.splitNeedle(src, ',');
    }

    public static Vector splitNeedle(String src, char needle) {
        int i;
        int len = src.length();
        boolean bInside = false;
        boolean bInsideString = false;
        int iPosBegin = 0;
        int iPosEnd = -1;
        Vector<String> result = new Vector<String>();
        for (i = 0; i < len; ++i) {
            char c = src.charAt(i);
            if (c == '\"') {
                if (!bInsideString) {
                    bInsideString = true;
                    bInside = true;
                    iPosBegin = i + 1;
                    continue;
                }
                bInsideString = false;
                iPosEnd = i;
                continue;
            }
            if (!bInsideString && c == needle) {
                if (!bInside) {
                    result.addElement("");
                    continue;
                }
                if (iPosEnd == -1) {
                    result.addElement(src.substring(iPosBegin, i).trim());
                } else {
                    result.addElement(src.substring(iPosBegin, iPosEnd).trim());
                }
                iPosEnd = -1;
                bInside = false;
                continue;
            }
            if (bInside) continue;
            bInside = true;
            iPosBegin = i;
        }
        if (bInside) {
            if (iPosEnd == -1) {
                result.addElement(src.substring(iPosBegin, i).trim());
            } else {
                result.addElement(src.substring(iPosBegin, iPosEnd).trim());
            }
        }
        return result;
    }

    public static String implode(String glue, Vector pieces) {
        if (glue == null) {
            glue = "";
        }
        if (pieces == null) {
            return "";
        }
        String result = "";
        boolean first = true;
        Enumeration e = pieces.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            result = first ? result + s : result + glue + s;
            first = false;
        }
        return result;
    }

    public static byte[] hexStringToByteArray(String src) {
        int len = src.length();
        return Utils.hexStringToByteArray(src, 0, len);
    }

    public static byte[] hexStringToByteArray(String src, int offset, int len) {
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(src.charAt(i), 16) << 4) + Character.digit(src.charAt(i + 1), 16));
        }
        return data;
    }

    public static String byteArrayToHexString(byte[] src) {
        int len = src.length;
        return Utils.byteArrayToHexString(src, 0, len);
    }

    public static String byteArrayToHexString(byte[] src, int offset, int len) {
        StringBuffer result = new StringBuffer(2 * len);
        for (int i = offset; i < offset + len; ++i) {
            byte b = src[i];
            result.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return result.toString();
    }

    public static StringBuffer byteArrayToHexStringWithSpaces(byte[] src, int offset, int len) {
        StringBuffer result = new StringBuffer(3 * len);
        boolean first = false;
        for (int i = offset; i < offset + len; ++i) {
            if (first) {
                first = false;
            } else {
                result.append(" ");
            }
            byte b = src[i];
            result.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return result;
    }

    public static String byteToHexString(int value) {
        StringBuffer result = new StringBuffer(2);
        result.append(HEXES.charAt(value >> 4 & 0xF)).append(HEXES.charAt(value & 0xF));
        return result.toString();
    }

    public static String clearBegginingOfString(String src) {
        int i;
        boolean bAsciiFound = false;
        for (i = 0; i < src.length(); ++i) {
            if (src.charAt(i) < '!' || src.charAt(i) > '~') continue;
            bAsciiFound = true;
            break;
        }
        if (i > 0 && bAsciiFound) {
            return src.substring(i);
        }
        return src;
    }

    public static String to2charStr(int value) {
        String result = Integer.toString(value);
        if (result.length() < 2) {
            result = "0" + result;
        }
        return result;
    }

    public static String formatDouble(double value, int fixed) {
        double pow = 1.0;
        for (int i = 1; i <= fixed; ++i) {
            pow *= 10.0;
        }
        value *= pow;
        value = Math.floor(value);
        return Double.toString(value /= pow);
    }

    public static String fillChar(char c, int count) {
        char[] result = new char[count];
        for (int i = 0; i < result.length; ++i) {
            result[i] = c;
        }
        return new String(result);
    }

    public static String formatHHMM(long src) {
        double f = src;
        double fh = Math.floor(f /= 3600000.0);
        double fm = f - fh;
        int hrs = (int)fh;
        int min = (int)(fm * 60.0);
        String sHrs = Integer.toString(hrs);
        String sMin = Integer.toString(min);
        if (sMin.length() == 1) {
            sMin = '0' + sMin;
        }
        return sHrs + ":" + sMin;
    }

    public static int swap(int value) {
        int b1 = value >> 0 & 0xFF;
        int b2 = value >> 8 & 0xFF;
        int b3 = value >> 16 & 0xFF;
        int b4 = value >> 24 & 0xFF;
        return b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0;
    }

    public static class RecEvent {
        public int type;
        public int eid;
    }
}

