/*
 * Decompiled with CFR 0.152.
 */
package com.sea.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PrimitiveDataInputStream
extends DataInputStream {
    protected boolean littleEndian;

    public PrimitiveDataInputStream(InputStream in) {
        super(in);
    }

    public PrimitiveDataInputStream(InputStream in, boolean alittleEndian) {
        this(in);
        this.littleEndian = alittleEndian;
    }

    public int readU8() throws IOException {
        return this.read();
    }

    public int readU16() throws IOException {
        int value;
        if (this.littleEndian) {
            value = this.read();
            value |= this.read() << 8;
        } else {
            value = this.read() << 8;
            value |= this.read();
        }
        return value;
    }

    public int readU24() throws IOException {
        int value;
        if (this.littleEndian) {
            value = this.read();
            value |= this.read() << 8;
            value |= this.read() << 16;
        } else {
            value = this.read() << 16;
            value |= this.read() << 8;
            value |= this.read();
        }
        return value;
    }

    public long readU32() throws IOException {
        int value;
        if (this.littleEndian) {
            value = this.read();
            value |= this.read() << 8;
            value |= this.read() << 16;
            value |= this.read() << 24;
        } else {
            value = this.read() << 24;
            value |= this.read() << 16;
            value |= this.read() << 8;
            value |= this.read();
        }
        return value;
    }
}

