/*
 * Decompiled with CFR 0.152.
 */
package com.sea.gbgs5;

import com.sea.gbgs5.CfgListener;
import com.sea.log.Logger;
import com.sea.utils.FileUtils;
import com.sea.utils.LineReader;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class Cfg {
    public static String modemImei;
    public static final String DEFAULT_SERIAL_NUMBER = "GF516001";
    public static String SERIAL_NUMBER;
    public static String PRODUCT_NAME;
    public static final int VARIANT_UNK = -1;
    public static final int VARIANT_GSM_R5_ZAS = 1;
    public static final int VARIANT_GSM_R5_ZAS_2A = 2;
    public static final int VARIANT_GSM_R5_ZAS_2IN = 3;
    public static final int VARIANT_GSM_R5_ZAS_5IN = 4;
    public static final int VARIANT_GSM_R5_ZAS_3OUT = 5;
    public static final int VARIANT_GSM_R5_RING = 6;
    public static final int VARIANT_GSM_R5_OHRADNIK = 7;
    public static final int VARIANT_GSM_R5_T = 8;
    public static final int VARIANT_GSM_SP11B = 9;
    public static final int VARIANT_GSM_MODBUS = 10;
    public static final int VARIANT_GSM_BGS5 = 11;
    public static int variant;
    public static int iLogLevel;
    private static Vector listeners;
    private static final String FILENAME_SERIAL_NUMBER = "file:///A:/sn.txt";
    private static final String FILENAME_CFG_ROOT = "file:///A:/cfg";

    static void init() {
        System.out.println("@Cfg.static init");
        Cfg.checkAndCreateCfgRoot();
        modemImei = "?????????????????????????";
        listeners = new Vector();
    }

    private static void log(String line) {
        Cfg.log(line, 4);
    }

    private static void log(String line, int level) {
        if (iLogLevel >= level) {
            Logger.log("@Cfg", line);
        }
    }

    public static void printConfiguration() {
        Cfg.log("Current configuration:");
    }

    public static void addListener(CfgListener item) {
        listeners.addElement(item);
    }

    public static void removeListener(CfgListener item) {
        listeners.removeElement(item);
    }

    public static void changed() {
        for (int i = 0; i < listeners.size(); ++i) {
            ((CfgListener)listeners.elementAt(i)).cfgChanged();
        }
    }

    public static void factory() throws IOException {
    }

    private static void checkAndCreateCfgRoot() {
        FileConnection fconn = null;
        try {
            fconn = (FileConnection)Connector.open((String)FILENAME_CFG_ROOT);
            if (!fconn.isDirectory()) {
                fconn.mkdir();
            }
        }
        catch (IOException e) {
            Cfg.log("[EXCEPTION] - " + e.getMessage(), 2);
        }
        finally {
            try {
                if (null != fconn) {
                    fconn.close();
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public static void detectSerialNumber() {
        String sResult = "";
        String sText = FileUtils.readTextFile(FILENAME_SERIAL_NUMBER);
        LineReader lReader = new LineReader(sText);
        String s = lReader.getLine();
        if (s != null && s.length() >= 3 && s.charAt(0) == 'G') {
            sResult = s.trim();
        }
        if (sResult.length() == 0) {
            sResult = DEFAULT_SERIAL_NUMBER;
        }
        if ((SERIAL_NUMBER = sResult).startsWith("GF0")) {
            variant = 5;
            PRODUCT_NAME = "GSM-R5-ZAS-3OUT";
        } else if (SERIAL_NUMBER.startsWith("GF1")) {
            variant = 2;
            PRODUCT_NAME = "GSM-R5-ZAS-2A";
        } else if (SERIAL_NUMBER.startsWith("GF2")) {
            variant = 3;
            PRODUCT_NAME = "GSM-R5-ZAS-2IN";
        } else if (SERIAL_NUMBER.startsWith("GF3")) {
            variant = 4;
            PRODUCT_NAME = "GSM-R5-ZAS-5IN";
        } else if (SERIAL_NUMBER.startsWith("GF4")) {
            variant = 8;
            PRODUCT_NAME = "GSM-R5-T";
        } else if (SERIAL_NUMBER.startsWith("GD3")) {
            variant = 6;
            PRODUCT_NAME = "GSM-RING";
        } else if (SERIAL_NUMBER.startsWith("GE4")) {
            variant = 7;
            PRODUCT_NAME = "GSM-OHRADNIK";
        } else if (SERIAL_NUMBER.startsWith("GF6")) {
            variant = 9;
            PRODUCT_NAME = "GSM-SP11B";
        } else if (SERIAL_NUMBER.startsWith("GF8")) {
            variant = 10;
            PRODUCT_NAME = "GSM-MODBUS";
        } else if (SERIAL_NUMBER.startsWith("GD5")) {
            variant = 11;
            PRODUCT_NAME = "GSM-BGS5";
        } else {
            variant = 1;
            PRODUCT_NAME = "GSM-R5-ZAS";
        }
    }

    static {
        SERIAL_NUMBER = DEFAULT_SERIAL_NUMBER;
        PRODUCT_NAME = "GSM-R5";
        variant = -1;
        iLogLevel = 4;
    }
}

