/*
 * Decompiled with CFR 0.152.
 */
package com.sea.gbgs5;

import com.sea.io.A4DataOutputStream;
import com.sea.io.PrimitiveDataInputStream;
import com.sea.io.VorByteArrayInputStream;
import com.sea.io.VorByteArrayOutputStream;
import com.sea.log.Logger;
import com.sea.utils.Crc8;
import com.sea.utils.TimeoutException;
import com.sea.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class A4Protocol
extends Thread {
    public final int UNKNOWN_AD_VALUE = Integer.MIN_VALUE;
    public int revisionH = -1;
    public int revisionL = -1;
    public int out2resp = 0;
    public int adVIn = Integer.MIN_VALUE;
    public int adVBatt = Integer.MIN_VALUE;
    public int adVCharge = Integer.MIN_VALUE;
    public int adPressureAdc = Integer.MIN_VALUE;
    public int btnCnt = -1;
    public long upTime = -1L;
    private static final int MAX_PACKET_LEN = 260;
    private static final int CMD_IO = 16;
    private static final int CMD_ADC = 20;
    private static final int CMD_MODEM_RESTART = 49;
    private static final int CMD_MODEM_SLEEP = 50;
    private static final int RESPONSE = 128;
    private static final int PROTO_STX = 164;
    private static final int PROTO_ETX = 163;
    protected boolean running = false;
    public int iLogLevel = 5;
    protected InputStream in = null;
    protected OutputStream out = null;
    protected int inTimeout;
    protected final byte[] inPacket = new byte[260];
    protected int inLen;
    protected boolean isPacketReceived;
    protected final VorByteArrayOutputStream outQuery = new VorByteArrayOutputStream(260);
    protected final A4DataOutputStream outData = new A4DataOutputStream(this.outQuery);
    protected byte[] response = new byte[260];
    protected final VorByteArrayInputStream inResponse = new VorByteArrayInputStream(this.response);
    protected final PrimitiveDataInputStream inData = new PrimitiveDataInputStream(this.inResponse);

    public A4Protocol(InputStream sin, OutputStream sout) {
        this.in = sin;
        this.out = sout;
        this.inTimeout = 1000;
    }

    public void startRunning() {
        this.running = true;
        this.start();
    }

    public void stopRunning() {
        this.running = false;
    }

    private void log(String line) {
        this.log(line, 4);
    }

    private void log(String line, int level) {
        if (this.iLogLevel >= level) {
            Logger.log("@A4", line);
        }
    }

    public void setInTimeout(int inTimeout) {
        this.inTimeout = inTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        byte[] inTemp = new byte[260];
        int pos = 0;
        int crc = 255;
        boolean insideOfPacket = false;
        while (this.running) {
            int j;
            int b;
            block12: {
                try {
                    b = this.in.read();
                    if (b == -1) break;
                    if (b < 0) {
                        b += 256;
                    }
                    if (b == 164) {
                        insideOfPacket = true;
                        pos = 0;
                        continue;
                    }
                    if (insideOfPacket && b == 163) {
                        j = 0;
                        this.inLen = 0;
                        break block12;
                    }
                    if (!insideOfPacket) continue;
                    inTemp[pos++] = (byte)b;
                    if (pos < inTemp.length) continue;
                    insideOfPacket = false;
                }
                catch (Exception e) {
                    try {
                        A4Protocol.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                continue;
            }
            for (int i = 0; i < pos / 2; ++this.inLen, ++i) {
                int bh;
                int n = (bh = inTemp[j++]) <= 57 ? 48 : 55;
                int bl = inTemp[j++];
                b = (bh -= n) << 4 | (bl -= bl <= 57 ? 48 : 55);
                this.inPacket[i] = (byte)b;
            }
            crc = Crc8.countCrc8(this.inPacket, 0, this.inLen);
            if (crc == 0) {
                byte[] byArray = this.inPacket;
                // MONITORENTER : this.inPacket
                this.isPacketReceived = true;
                this.inPacket.notify();
                // MONITOREXIT : byArray
                continue;
            }
            this.log("[ERROR] - Received packet with invalid CRC - raw: " + Utils.pckt2str(inTemp, 0, pos), 2);
            this.log("[ERROR] - Received packet with invalid CRC - decoded: " + Utils.pckt2str(this.inPacket, 0, this.inLen), 2);
        }
        this.log("Thread finished.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void transact(VorByteArrayOutputStream os, VorByteArrayInputStream is) throws IOException, InterruptedException {
        this.isPacketReceived = false;
        this.out.write(os.getByteArray(), 0, os.getCount());
        byte[] byArray = this.inPacket;
        synchronized (this.inPacket) {
            this.inPacket.wait(this.inTimeout);
            if (!this.isPacketReceived) {
                throw new TimeoutException("Timeout");
            }
            this.inResponse.copyFrom(this.inPacket, 0, this.inLen);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void io(int out2, int led_out2, int led_gsm, int rs485baud, int rs485set) throws Exception {
        VorByteArrayOutputStream vorByteArrayOutputStream = this.outQuery;
        synchronized (vorByteArrayOutputStream) {
            this.outQuery.reset();
            this.outData.begin(16);
            this.outData.writeU8(out2);
            this.outData.writeU8(led_out2);
            this.outData.writeU8(led_gsm);
            this.outData.writeU8(rs485baud);
            this.outData.writeU8(rs485set);
            this.outData.end();
            this.transact(this.outQuery, this.inResponse);
            int cmd = this.inData.readU8();
            if (cmd == 144) {
                this.revisionH = this.inData.readU8();
                this.revisionL = this.inData.readU8();
                this.out2resp = this.inData.readU8();
                this.adVIn = this.inData.readU16();
                this.adVBatt = this.inData.readU16();
                this.adVCharge = this.inData.readU16();
                this.btnCnt = this.inData.readU8();
                this.upTime = this.inData.readU32();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adc() throws IOException, InterruptedException {
        VorByteArrayOutputStream vorByteArrayOutputStream = this.outQuery;
        synchronized (vorByteArrayOutputStream) {
            this.outQuery.reset();
            this.outData.begin(20);
            this.outData.writeU8(0);
            this.outData.writeU8(8);
            this.outData.end();
            this.transact(this.outQuery, this.inResponse);
            int cmd = this.inData.readU8();
            if (cmd == 148) {
                this.adVIn = this.inData.readU16();
                this.adVBatt = this.inData.readU16();
                this.adVCharge = this.inData.readU16();
                this.adPressureAdc = this.inData.readU16();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restart() throws IOException, InterruptedException {
        VorByteArrayOutputStream vorByteArrayOutputStream = this.outQuery;
        synchronized (vorByteArrayOutputStream) {
            this.outQuery.reset();
            this.outData.begin(49);
            this.outData.writeU8(1);
            this.outData.end();
            this.transact(this.outQuery, this.inResponse);
            int cmd = this.inData.readU8();
            if (cmd == 177) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sleep() throws IOException, InterruptedException {
        VorByteArrayOutputStream vorByteArrayOutputStream = this.outQuery;
        synchronized (vorByteArrayOutputStream) {
            this.outQuery.reset();
            this.outData.begin(50);
            this.outData.writeU8(1);
            this.outData.end();
            this.transact(this.outQuery, this.inResponse);
            int cmd = this.inData.readU8();
            if (cmd == 178) {
                // empty if block
            }
        }
    }
}

