/*
 * Decompiled with CFR 0.152.
 */
package me.regexp;

import java.util.Hashtable;
import me.regexp.REProgram;
import me.regexp.RESyntaxException;

public class RECompiler {
    char[] instruction = new char[128];
    int lenInstruction = 0;
    String pattern;
    int len;
    int idx;
    int parens;
    static final int NODE_NORMAL = 0;
    static final int NODE_NULLABLE = 1;
    static final int NODE_TOPLEVEL = 2;
    static final int ESC_MASK = 1048560;
    static final int ESC_BACKREF = 1048575;
    static final int ESC_COMPLEX = 1048574;
    static final int ESC_CLASS = 1048573;
    static final int bracketUnbounded = -1;
    int bracketMin;
    int bracketOpt;
    static final Hashtable hashPOSIX = new Hashtable();

    void ensure(int n) {
        int n2 = this.instruction.length;
        if (this.lenInstruction + n >= n2) {
            while (this.lenInstruction + n >= n2) {
                n2 *= 2;
            }
            char[] cArray = new char[n2];
            System.arraycopy(this.instruction, 0, cArray, 0, this.lenInstruction);
            this.instruction = cArray;
        }
    }

    void emit(char c) {
        this.ensure(1);
        this.instruction[this.lenInstruction++] = c;
    }

    void nodeInsert(char c, int n, int n2) {
        this.ensure(3);
        System.arraycopy(this.instruction, n2, this.instruction, n2 + 3, this.lenInstruction - n2);
        this.instruction[n2] = c;
        this.instruction[n2 + 1] = (char)n;
        this.instruction[n2 + 2] = '\u0000';
        this.lenInstruction += 3;
    }

    void setNextOfEnd(int n, int n2) {
        char c = this.instruction[n + 2];
        while (c != '\u0000' && n < this.lenInstruction) {
            if (n == n2) {
                n2 = this.lenInstruction;
            }
            c = this.instruction[(n += c) + 2];
        }
        if (n < this.lenInstruction) {
            int n3 = n2 - n;
            if (n3 != (short)n3) {
                throw new RESyntaxException("Exceeded short jump range.");
            }
            this.instruction[n + 2] = (char)n3;
        }
    }

    int node(char c, int n) {
        this.ensure(3);
        this.instruction[this.lenInstruction] = c;
        this.instruction[this.lenInstruction + 1] = (char)n;
        this.instruction[this.lenInstruction + 2] = '\u0000';
        this.lenInstruction += 3;
        return this.lenInstruction - 3;
    }

    void internalError() throws Error {
        throw new Error("Internal error!");
    }

    void syntaxError(String string) throws RESyntaxException {
        throw new RESyntaxException(string);
    }

    void bracket() throws RESyntaxException {
        if (this.idx >= this.len || this.pattern.charAt(this.idx++) != '{') {
            this.internalError();
        }
        if (this.idx >= this.len || !Character.isDigit(this.pattern.charAt(this.idx))) {
            this.syntaxError("Expected digit");
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
            stringBuffer.append(this.pattern.charAt(this.idx++));
        }
        try {
            this.bracketMin = Integer.parseInt(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            this.syntaxError("Expected valid number");
        }
        if (this.idx >= this.len) {
            this.syntaxError("Expected comma or right bracket");
        }
        if (this.pattern.charAt(this.idx) == '}') {
            ++this.idx;
            this.bracketOpt = 0;
            return;
        }
        if (this.idx >= this.len || this.pattern.charAt(this.idx++) != ',') {
            this.syntaxError("Expected comma");
        }
        if (this.idx >= this.len) {
            this.syntaxError("Expected comma or right bracket");
        }
        if (this.pattern.charAt(this.idx) == '}') {
            ++this.idx;
            this.bracketOpt = -1;
            return;
        }
        if (this.idx >= this.len || !Character.isDigit(this.pattern.charAt(this.idx))) {
            this.syntaxError("Expected digit");
        }
        stringBuffer.setLength(0);
        while (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
            stringBuffer.append(this.pattern.charAt(this.idx++));
        }
        try {
            this.bracketOpt = Integer.parseInt(stringBuffer.toString()) - this.bracketMin;
        }
        catch (NumberFormatException numberFormatException) {
            this.syntaxError("Expected valid number");
        }
        if (this.bracketOpt < 0) {
            this.syntaxError("Bad range");
        }
        if (this.idx >= this.len || this.pattern.charAt(this.idx++) != '}') {
            this.syntaxError("Missing close brace");
        }
    }

    int escape() throws RESyntaxException {
        if (this.pattern.charAt(this.idx) != '\\') {
            this.internalError();
        }
        if (this.idx + 1 == this.len) {
            this.syntaxError("Escape terminates string");
        }
        this.idx += 2;
        char c = this.pattern.charAt(this.idx - 1);
        switch (c) {
            case 'B': 
            case 'b': {
                return 1048574;
            }
            case 'D': 
            case 'S': 
            case 'W': 
            case 'd': 
            case 's': 
            case 'w': {
                return 1048573;
            }
            case 'u': 
            case 'x': {
                int n = c == 'u' ? 4 : 2;
                int n2 = 0;
                while (this.idx < this.len && n-- > 0) {
                    char c2 = this.pattern.charAt(this.idx);
                    if (c2 >= '0' && c2 <= '9') {
                        n2 = (n2 << 4) + c2 - 48;
                    } else if ((c2 = Character.toLowerCase(c2)) >= 'a' && c2 <= 'f') {
                        n2 = (n2 << 4) + (c2 - 97) + 10;
                    } else {
                        this.syntaxError("Expected " + n + " hexadecimal digits after \\" + c);
                    }
                    ++this.idx;
                }
                return n2;
            }
            case 't': {
                return 9;
            }
            case 'n': {
                return 10;
            }
            case 'r': {
                return 13;
            }
            case 'f': {
                return 12;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx)) || c == '0') {
                    int n = c - 48;
                    if (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
                        n = (n << 3) + (this.pattern.charAt(this.idx++) - 48);
                        if (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
                            n = (n << 3) + (this.pattern.charAt(this.idx++) - 48);
                        }
                    }
                    return n;
                }
                return 1048575;
            }
        }
        return c;
    }

    int characterClass() throws RESyntaxException {
        int n;
        int n2;
        int n3;
        if (this.pattern.charAt(this.idx) != '[') {
            this.internalError();
        }
        if (this.idx + 1 >= this.len || this.pattern.charAt(++this.idx) == ']') {
            this.syntaxError("Empty or unterminated class");
        }
        if (this.idx < this.len && this.pattern.charAt(this.idx) == ':') {
            ++this.idx;
            n3 = this.idx;
            while (this.idx < this.len && this.pattern.charAt(this.idx) >= 'a' && this.pattern.charAt(this.idx) <= 'z') {
                ++this.idx;
            }
            if (this.idx + 1 < this.len && this.pattern.charAt(this.idx) == ':' && this.pattern.charAt(this.idx + 1) == ']') {
                String string = this.pattern.substring(n3, this.idx);
                Character c = (Character)hashPOSIX.get(string);
                if (c != null) {
                    this.idx += 2;
                    return this.node('P', c.charValue());
                }
                this.syntaxError("Invalid POSIX character class '" + string + "'");
            }
            this.syntaxError("Invalid POSIX character class syntax");
        }
        n3 = this.node('[', 0);
        int n4 = n2 = 65535;
        boolean bl = true;
        boolean bl2 = false;
        int n5 = this.idx;
        int n6 = 0;
        RERange rERange = new RERange();
        block18: while (this.idx < this.len && this.pattern.charAt(this.idx) != ']') {
            int n7;
            switch (this.pattern.charAt(this.idx)) {
                case '^': {
                    boolean bl3 = bl = !bl;
                    if (this.idx == n5) {
                        rERange.include(0, 65535, true);
                    }
                    ++this.idx;
                    continue block18;
                }
                case '\\': {
                    n = this.escape();
                    switch (n) {
                        case 1048574: 
                        case 1048575: {
                            this.syntaxError("Bad character class");
                        }
                        case 1048573: {
                            if (bl2) {
                                this.syntaxError("Bad character class");
                            }
                            switch (this.pattern.charAt(this.idx - 1)) {
                                case 'S': {
                                    rERange.include(0, 7, bl);
                                    rERange.include('\u000b', bl);
                                    rERange.include(14, 31, bl);
                                    rERange.include(33, 65535, bl);
                                    break;
                                }
                                case 'W': {
                                    rERange.include(0, 47, bl);
                                    rERange.include(58, 64, bl);
                                    rERange.include(91, 94, bl);
                                    rERange.include('`', bl);
                                    rERange.include(123, 65535, bl);
                                    break;
                                }
                                case 'D': {
                                    rERange.include(0, 47, bl);
                                    rERange.include(58, 65535, bl);
                                    break;
                                }
                                case 's': {
                                    rERange.include('\t', bl);
                                    rERange.include('\r', bl);
                                    rERange.include('\f', bl);
                                    rERange.include('\n', bl);
                                    rERange.include('\b', bl);
                                    rERange.include(' ', bl);
                                    break;
                                }
                                case 'w': {
                                    rERange.include(97, 122, bl);
                                    rERange.include(65, 90, bl);
                                    rERange.include('_', bl);
                                }
                                case 'd': {
                                    rERange.include(48, 57, bl);
                                }
                            }
                            n4 = n2;
                            continue block18;
                        }
                    }
                    n7 = n;
                    break;
                }
                case '-': {
                    if (bl2) {
                        this.syntaxError("Bad class range");
                    }
                    bl2 = true;
                    int n8 = n6 = n4 == n2 ? 0 : n4;
                    if (this.idx + 1 >= this.len || this.pattern.charAt(++this.idx) != ']') continue block18;
                    n7 = 65535;
                    break;
                }
                default: {
                    n7 = this.pattern.charAt(this.idx++);
                }
            }
            if (bl2) {
                int n9 = n7;
                if (n6 >= n9) {
                    this.syntaxError("Bad character class");
                }
                rERange.include(n6, n9, bl);
                n4 = n2;
                bl2 = false;
                continue;
            }
            if (this.idx >= this.len || this.pattern.charAt(this.idx) != '-') {
                rERange.include((char)n7, bl);
            }
            n4 = n7;
        }
        if (this.idx == this.len) {
            this.syntaxError("Unterminated character class");
        }
        ++this.idx;
        this.instruction[n3 + 1] = (char)rERange.num;
        for (n = 0; n < rERange.num; ++n) {
            this.emit((char)rERange.minRange[n]);
            this.emit((char)rERange.maxRange[n]);
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    int atom() throws RESyntaxException {
        var1_1 = this.node('A', 0);
        var2_2 = 0;
        block8: while (this.idx < this.len) {
            if (this.idx + 1 >= this.len) ** GOTO lbl-1000
            var3_3 = this.pattern.charAt(this.idx + 1);
            if (this.pattern.charAt(this.idx) == '\\') {
                var4_4 = this.idx;
                this.escape();
                if (this.idx < this.len) {
                    var3_3 = this.pattern.charAt(this.idx);
                }
                this.idx = var4_4;
            }
            switch (var3_3) {
                case 42: 
                case 43: 
                case 63: 
                case 123: {
                    if (var2_2 != 0) break block8;
                }
                default: lbl-1000:
                // 2 sources

                {
                    switch (this.pattern.charAt(this.idx)) {
                        case '$': 
                        case '(': 
                        case ')': 
                        case '.': 
                        case '[': 
                        case ']': 
                        case '^': 
                        case '|': {
                            break block8;
                        }
                        case '*': 
                        case '+': 
                        case '?': 
                        case '{': {
                            if (var2_2 != 0) break block8;
                            this.syntaxError("Missing operand to closure");
                            break block8;
                        }
                        case '\\': {
                            var3_3 = this.idx;
                            var4_4 = this.escape();
                            if ((var4_4 & 1048560) == 1048560) {
                                this.idx = var3_3;
                                break block8;
                            }
                            this.emit((char)var4_4);
                            ++var2_2;
                            continue block8;
                        }
                        default: {
                            this.emit(this.pattern.charAt(this.idx++));
                            ++var2_2;
                            continue block8;
                        }
                    }
                }
            }
        }
        if (var2_2 == 0) {
            this.internalError();
        }
        this.instruction[var1_1 + 1] = (char)var2_2;
        return var1_1;
    }

    int terminal(int[] nArray) throws RESyntaxException {
        switch (this.pattern.charAt(this.idx)) {
            case '$': 
            case '.': 
            case '^': {
                return this.node(this.pattern.charAt(this.idx++), 0);
            }
            case '[': {
                return this.characterClass();
            }
            case '(': {
                return this.expr(nArray);
            }
            case ')': {
                this.syntaxError("Unexpected close paren");
            }
            case '|': {
                this.internalError();
            }
            case ']': {
                this.syntaxError("Mismatched class");
            }
            case '\u0000': {
                this.syntaxError("Unexpected end of input");
            }
            case '*': 
            case '+': 
            case '?': 
            case '{': {
                this.syntaxError("Missing operand to closure");
            }
            case '\\': {
                int n = this.idx;
                switch (this.escape()) {
                    case 1048573: 
                    case 1048574: {
                        nArray[0] = nArray[0] & 0xFFFFFFFE;
                        return this.node('\\', this.pattern.charAt(this.idx - 1));
                    }
                    case 1048575: {
                        char c = (char)(this.pattern.charAt(this.idx - 1) - 48);
                        if (this.parens <= c) {
                            this.syntaxError("Bad backreference");
                        }
                        nArray[0] = nArray[0] | 1;
                        return this.node('#', c);
                    }
                }
                this.idx = n;
                nArray[0] = nArray[0] & 0xFFFFFFFE;
            }
        }
        nArray[0] = nArray[0] & 0xFFFFFFFE;
        return this.atom();
    }

    int closure(int[] nArray) throws RESyntaxException {
        int n;
        int n2 = this.idx;
        int[] nArray2 = new int[]{0};
        int n3 = this.terminal(nArray2);
        nArray[0] = nArray[0] | nArray2[0];
        if (this.idx >= this.len) {
            return n3;
        }
        boolean bl = true;
        char c = this.pattern.charAt(this.idx);
        switch (c) {
            case '*': 
            case '?': {
                nArray[0] = nArray[0] | 1;
            }
            case '+': {
                ++this.idx;
            }
            case '{': {
                n = this.instruction[n3];
                if (n == 94 || n == 36) {
                    this.syntaxError("Bad closure operand");
                }
                if ((nArray2[0] & 1) == 0) break;
                this.syntaxError("Closure operand can't be nullable");
            }
        }
        if (this.idx < this.len && this.pattern.charAt(this.idx) == '?') {
            ++this.idx;
            bl = false;
        }
        if (bl) {
            switch (c) {
                case '{': {
                    this.bracket();
                    n = this.idx;
                    int n4 = this.bracketMin;
                    int n5 = this.bracketOpt;
                    int n6 = n3;
                    for (int i = 0; i < n4; ++i) {
                        this.idx = n2;
                        int n7 = n6;
                        n6 = this.terminal(nArray2);
                        this.setNextOfEnd(n7, n6);
                    }
                    if (n5 == -1) {
                        this.idx = n;
                        this.nodeInsert('*', 0, n6);
                        this.setNextOfEnd(n6 + 3, n6);
                        break;
                    }
                    if (n5 > 0) {
                        int n8;
                        int[] nArray3 = new int[n5 + 1];
                        this.nodeInsert('?', 0, n6);
                        nArray3[0] = n6;
                        for (n8 = 1; n8 < n5; ++n8) {
                            nArray3[n8] = this.node('?', 0);
                            this.idx = n2;
                            this.terminal(nArray2);
                        }
                        n8 = nArray3[n5] = this.node('N', 0);
                        for (int i = 0; i < n5; ++i) {
                            this.setNextOfEnd(nArray3[i], n8);
                            this.setNextOfEnd(nArray3[i] + 3, nArray3[i + 1]);
                        }
                    } else {
                        this.lenInstruction = n6;
                        this.node('N', 0);
                    }
                    this.idx = n;
                    break;
                }
                case '?': {
                    this.nodeInsert('?', 0, n3);
                    n = this.node('N', 0);
                    this.setNextOfEnd(n3, n);
                    this.setNextOfEnd(n3 + 3, n);
                    break;
                }
                case '*': {
                    this.nodeInsert('*', 0, n3);
                    this.setNextOfEnd(n3 + 3, n3);
                    break;
                }
                case '+': {
                    this.nodeInsert('C', 0, n3);
                    n = this.node('+', 0);
                    this.setNextOfEnd(n3 + 3, n);
                    this.setNextOfEnd(n, n3);
                    break;
                }
            }
        } else {
            switch (c) {
                case '?': {
                    this.nodeInsert('/', 0, n3);
                    n = this.node('N', 0);
                    this.setNextOfEnd(n3, n);
                    this.setNextOfEnd(n3 + 3, n);
                    break;
                }
                case '*': {
                    this.nodeInsert('8', 0, n3);
                    this.setNextOfEnd(n3 + 3, n3);
                    break;
                }
                case '+': {
                    this.nodeInsert('C', 0, n3);
                    n = this.node('=', 0);
                    this.setNextOfEnd(n, n3);
                    this.setNextOfEnd(n3 + 3, n);
                    break;
                }
            }
        }
        return n3;
    }

    int branch(int[] nArray) throws RESyntaxException {
        int n = -1;
        int n2 = -1;
        int[] nArray2 = new int[1];
        boolean bl = true;
        while (this.idx < this.len && this.pattern.charAt(this.idx) != '|' && this.pattern.charAt(this.idx) != ')') {
            nArray2[0] = 0;
            int n3 = this.closure(nArray2);
            if (nArray2[0] == 0) {
                bl = false;
            }
            if (n2 != -1) {
                this.setNextOfEnd(n2, n3);
            }
            n2 = n3;
            if (n != -1) continue;
            n = n3;
        }
        if (n == -1) {
            n = this.node('N', 0);
        }
        if (bl) {
            nArray[0] = nArray[0] | 1;
        }
        return n;
    }

    int expr(int[] nArray) throws RESyntaxException {
        int n;
        int n2;
        int n3 = -1;
        int n4 = -1;
        int n5 = this.parens;
        if ((nArray[0] & 2) == 0 && this.pattern.charAt(this.idx) == '(') {
            if (this.idx + 2 < this.len && this.pattern.charAt(this.idx + 1) == '?' && this.pattern.charAt(this.idx + 2) == ':') {
                n3 = 2;
                this.idx += 3;
                n4 = this.node('<', 0);
            } else {
                n3 = 1;
                ++this.idx;
                n4 = this.node('(', this.parens++);
            }
        }
        nArray[0] = nArray[0] & 0xFFFFFFFD;
        boolean bl = false;
        int n6 = this.branch(nArray);
        if (n4 == -1) {
            n4 = n6;
        } else {
            this.setNextOfEnd(n4, n6);
        }
        while (this.idx < this.len && this.pattern.charAt(this.idx) == '|') {
            if (!bl) {
                this.nodeInsert('|', 0, n6);
                bl = true;
            }
            ++this.idx;
            int n7 = n6;
            n6 = this.node('|', 0);
            this.setNextOfEnd(n7, n6);
            this.branch(nArray);
        }
        if (n3 > 0) {
            if (this.idx < this.len && this.pattern.charAt(this.idx) == ')') {
                ++this.idx;
            } else {
                this.syntaxError("Missing close paren");
            }
            n2 = n3 == 1 ? this.node(')', n5) : this.node('>', 0);
        } else {
            n2 = this.node('E', 0);
        }
        this.setNextOfEnd(n4, n2);
        char c = this.instruction[n + 2];
        for (n = n4; c != '\u0000' && n < this.lenInstruction; n += c) {
            if (this.instruction[n] == '|') {
                this.setNextOfEnd(n + 3, n2);
            }
            c = this.instruction[n + 2];
        }
        return n4;
    }

    public REProgram compile(String string) throws RESyntaxException {
        this.pattern = string;
        this.len = string.length();
        this.idx = 0;
        this.lenInstruction = 0;
        this.parens = 1;
        int[] nArray = new int[]{2};
        this.expr(nArray);
        if (this.idx != this.len) {
            if (string.charAt(this.idx) == ')') {
                this.syntaxError("Unmatched close paren");
            }
            this.syntaxError("Unexpected input remains");
        }
        char[] cArray = new char[this.lenInstruction];
        System.arraycopy(this.instruction, 0, cArray, 0, this.lenInstruction);
        return new REProgram(this.parens, cArray);
    }

    static {
        hashPOSIX.put("alnum", new Character('w'));
        hashPOSIX.put("alpha", new Character('a'));
        hashPOSIX.put("blank", new Character('b'));
        hashPOSIX.put("cntrl", new Character('c'));
        hashPOSIX.put("digit", new Character('d'));
        hashPOSIX.put("graph", new Character('g'));
        hashPOSIX.put("lower", new Character('l'));
        hashPOSIX.put("print", new Character('p'));
        hashPOSIX.put("punct", new Character('!'));
        hashPOSIX.put("space", new Character('s'));
        hashPOSIX.put("upper", new Character('u'));
        hashPOSIX.put("xdigit", new Character('x'));
        hashPOSIX.put("javastart", new Character('j'));
        hashPOSIX.put("javapart", new Character('k'));
    }

    class RERange {
        int size = 16;
        int[] minRange = new int[this.size];
        int[] maxRange = new int[this.size];
        int num = 0;

        RERange() {
        }

        void delete(int n) {
            if (this.num == 0 || n >= this.num) {
                return;
            }
            while (++n < this.num) {
                if (n - 1 < 0) continue;
                this.minRange[n - 1] = this.minRange[n];
                this.maxRange[n - 1] = this.maxRange[n];
            }
            --this.num;
        }

        void merge(int n, int n2) {
            for (int i = 0; i < this.num; ++i) {
                if (n >= this.minRange[i] && n2 <= this.maxRange[i]) {
                    return;
                }
                if (n <= this.minRange[i] && n2 >= this.maxRange[i]) {
                    this.delete(i);
                    this.merge(n, n2);
                    return;
                }
                if (n >= this.minRange[i] && n <= this.maxRange[i]) {
                    n = this.minRange[i];
                    this.delete(i);
                    this.merge(n, n2);
                    return;
                }
                if (n2 < this.minRange[i] || n2 > this.maxRange[i]) continue;
                n2 = this.maxRange[i];
                this.delete(i);
                this.merge(n, n2);
                return;
            }
            if (this.num >= this.size) {
                this.size *= 2;
                int[] nArray = new int[this.size];
                int[] nArray2 = new int[this.size];
                System.arraycopy(this.minRange, 0, nArray, 0, this.num);
                System.arraycopy(this.maxRange, 0, nArray2, 0, this.num);
                this.minRange = nArray;
                this.maxRange = nArray2;
            }
            this.minRange[this.num] = n;
            this.maxRange[this.num] = n2;
            ++this.num;
        }

        void remove(int n, int n2) {
            for (int i = 0; i < this.num; ++i) {
                if (this.minRange[i] >= n && this.maxRange[i] <= n2) {
                    this.delete(i);
                    return;
                }
                if (n >= this.minRange[i] && n2 <= this.maxRange[i]) {
                    int n3 = this.minRange[i];
                    int n4 = this.maxRange[i];
                    this.delete(i);
                    if (n3 < n) {
                        this.merge(n3, n - 1);
                    }
                    if (n2 < n4) {
                        this.merge(n2 + 1, n4);
                    }
                    return;
                }
                if (this.minRange[i] >= n && this.minRange[i] <= n2) {
                    this.minRange[i] = n2 + 1;
                    return;
                }
                if (this.maxRange[i] < n || this.maxRange[i] > n2) continue;
                this.maxRange[i] = n - 1;
                return;
            }
        }

        void include(int n, int n2, boolean bl) {
            if (bl) {
                this.merge(n, n2);
            } else {
                this.remove(n, n2);
            }
        }

        void include(char c, boolean bl) {
            this.include(c, c, bl);
        }
    }
}

