/*
 * Decompiled with CFR 0.152.
 */
package com.sea.io;

import com.sea.utils.Crc8;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class A4DataOutputStream
extends DataOutputStream {
    private static final int PROTO_STX = 164;
    private static final int PROTO_ETX = 163;
    protected int crc8;

    public A4DataOutputStream(OutputStream out) {
        super(out);
    }

    public void begin(int cmd) throws IOException {
        this.crc8 = 255;
        this.write(164);
        this.writeU8(cmd);
    }

    public void end() throws IOException {
        this.writeU8(this.crc8);
        this.write(163);
    }

    public void writeU8(int value) throws IOException {
        Crc8.update(this.crc8, value);
        int bh = value >> 4 & 0xF;
        int bl = value & 0xF;
        int n = bl <= 9 ? 48 : 55;
        this.write(bh += bh <= 9 ? 48 : 55);
        this.write(bl += n);
    }
}

