/*
 * Decompiled with CFR 0.152.
 */
package com.sea.gbgs5;

import com.sea.gbgs5.A4Protocol;
import com.sea.log.Logger;
import com.sea.utils.Watchdog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.CommConnection;
import javax.microedition.io.Connector;

public class Slave
extends Thread {
    public static final int LD_OFF = 0;
    public static final int LD_ON = 1;
    public static final int LD_AUTO = 2;
    public static final int LD_EQUAL = 3;
    public static final int LD_BLINK_FAST = 4;
    public static final int LD_BLINK_SLOW = 5;
    private static final String CONNECTION_STRING = "comm:COM1;baudrate=115200;autocts=on;autorts=on";
    private static final int LINES_TO_SKIP = 10;
    private static Slave instance = null;
    private static boolean bRunning = false;
    public static final int iLogLevel = 4;
    private static InputStream in = null;
    private static OutputStream out = null;
    private CommConnection commConn = null;
    private static A4Protocol proto;
    private int out2 = 0;
    private int led_out2 = 2;
    private int led_gsm = 2;
    private boolean led_out2_override = false;
    private int led_out2_override_value;
    private boolean led_gsm_override = false;
    private int led_gsm_override_value;
    private boolean bForceHwReset = false;
    private boolean bForceSleep = false;
    private boolean bDebugAutoReport = false;
    private int iDebugLineCount;

    public static Slave getInstance() {
        if (instance == null) {
            instance = new Slave();
        }
        return instance;
    }

    public void startRunning() {
        bRunning = true;
        this.start();
    }

    public void stopRunning() {
        bRunning = false;
        this.interrupt();
    }

    protected static void log(String line) {
        Slave.log(line, 4);
    }

    protected static void log(String line, int level) {
        if (4 >= level) {
            Logger.log("@Slave", line);
        }
    }

    public void run() {
        Slave.log("Thread started", 0);
        this.commConn = null;
        Watchdog.getInstance().register(this);
        this.iDebugLineCount = 0;
        this.bForceHwReset = false;
        while (bRunning) {
            try {
                if (this.commConn == null) {
                    Slave.log("Opening connection to slave - comm:COM1;baudrate=115200;autocts=on;autorts=on");
                    this.openPort();
                }
                try {
                    if (this.bForceHwReset) {
                        this.bForceHwReset = false;
                        proto.restart();
                    }
                    if (this.bForceSleep) {
                        this.bForceSleep = false;
                        proto.sleep();
                    }
                    int led_out2_real = this.led_out2_override ? this.led_out2_override_value : this.led_out2;
                    int led_gsm_real = this.led_gsm_override ? this.led_gsm_override_value : this.led_gsm;
                    proto.io(this.out2, led_out2_real, led_gsm_real, 44, 17);
                    if ((Slave.proto.out2resp & 2) != 0) {
                        this.out2 = Slave.proto.out2resp & 1;
                    }
                    if (this.bDebugAutoReport && this.iDebugLineCount++ > 10) {
                        this.printReport();
                        this.iDebugLineCount = 0;
                    }
                    Slave.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Watchdog.getInstance().kick(this, 10);
            }
            catch (Exception e) {
                Slave.log("[ EXCEPTION ] - '" + e.toString() + "'", 2);
                e.printStackTrace();
            }
        }
        this.closePort();
        Slave.log("Thread finished", 0);
    }

    private void openPort() throws IOException {
        this.commConn = (CommConnection)Connector.open((String)CONNECTION_STRING, (int)3, (boolean)true);
        in = this.commConn.openInputStream();
        out = this.commConn.openDataOutputStream();
        proto = new A4Protocol(in, out);
        proto.startRunning();
    }

    private void closePort() {
        if (proto != null) {
            proto.stopRunning();
            proto = null;
        }
        if (out != null) {
            try {
                out.flush();
                out.close();
                out = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (in != null) {
            try {
                in.close();
                in = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.commConn != null) {
            try {
                this.commConn.close();
                this.commConn = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String setOut(int pin, int state) {
        if (pin == 0) {
            this.out2 = state != 0 ? 1 : 0;
            this.interrupt();
            return "OK";
        }
        return "[ERROR] - Index out of bounds";
    }

    public void setLedOut(int mode) {
        Slave.log("setLedOut(" + mode + ")");
        this.led_out2 = mode;
    }

    public void overrideLedOut(boolean on, int value) {
        this.led_out2_override = on;
        this.led_out2_override_value = value;
    }

    public void overrideLedGsm(boolean on, int value) {
        this.led_gsm_override = on;
        this.led_gsm_override_value = value;
    }

    public void forceHwReset() {
        this.bForceHwReset = true;
    }

    public void sleep() {
        this.bForceSleep = true;
    }

    public int getOut() {
        return this.out2;
    }

    public void reportOnceAndPause() {
        this.bDebugAutoReport = false;
        this.printReport();
    }

    public void resume(int value) {
        this.iDebugLineCount = 10;
        this.bDebugAutoReport = true;
    }

    public void printReport() {
        Slave.log("out=" + Slave.proto.out2resp + " Vin=" + Slave.proto.adVIn + "mV Vbatt=" + Slave.proto.adVBatt + "mV Vcharge=" + Slave.proto.adVCharge + "mV btnCnt=" + Slave.proto.btnCnt + " uptime=" + Slave.proto.upTime);
    }
}

