/*
 * Decompiled with CFR 0.152.
 */
package com.sea.gbgs5;

import com.sea.gbgs5.Cfg;
import com.sea.gbgs5.ConsoleReporter;
import com.sea.gbgs5.Main;
import com.sea.gbgs5.Slave;
import com.sea.log.Logger;
import com.sea.modem.SyncAtCommand;
import com.sea.utils.FileUtils;
import com.sea.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.CommConnection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class Console
extends Thread {
    private static final String CONNECTION_STRING = "comm:USB0;baudrate=115200;autocts=on;autorts=on";
    private static final String FILEPATH_CALIBRATION = "file:///A:/factory_calibration/";
    private static Console instance;
    private boolean bRunning;
    private SyncAtCommand atc;
    public static final int iLogLevel = 4;
    private Vector vDeviceInfo;
    private InputStream ins;
    private CommConnection commConn;

    public static Console getInstance() {
        if (instance == null) {
            instance = new Console();
        }
        return instance;
    }

    public void startRunning() {
        this.bRunning = true;
        this.start();
    }

    public void stopRunning() {
        this.bRunning = false;
        this.interrupt();
    }

    protected static void log(String line) {
        Console.log(line, 4);
    }

    protected static void log(String line, int level) {
        if (4 >= level) {
            Logger.log("@Console", line);
        }
    }

    public void registerAtCommand(SyncAtCommand aSyncAtCommand) {
        this.atc = aSyncAtCommand;
    }

    public void run() {
        boolean bAuthorized = false;
        Console.log("Thread started", 0);
        this.commConn = null;
        block16: while (this.bRunning) {
            try {
                if (this.commConn == null) {
                    Console.log("Opening connection for Console - comm:USB0;baudrate=115200;autocts=on;autorts=on");
                    this.openPort();
                }
                if (!bAuthorized) {
                    System.out.println("Enter 'console'<cr> to enter command mode.");
                }
                String line = this.readln(this.ins);
                if (!bAuthorized && line.equalsIgnoreCase("console")) {
                    bAuthorized = true;
                    line = "-";
                }
                if (!bAuthorized) continue;
                char cc = line.length() >= 1 ? (char)line.charAt(0) : (char)'-';
                cc = Character.toLowerCase(cc);
                switch (cc) {
                    case 'a': {
                        if (line.startsWith("AT") || line.startsWith("at")) {
                            String response = this.atc.send(line + "\r");
                            System.out.println(response);
                            break;
                        }
                        System.out.println("ERROR - AT command must begin with 'at'");
                        break;
                    }
                    case 'c': {
                        Cfg.printConfiguration();
                        break;
                    }
                    case 'd': {
                        int value;
                        String s;
                        if (line.length() > 1) {
                            s = line.substring(1);
                            value = Integer.parseInt(s);
                        } else {
                            value = 0;
                        }
                        if (value == 0) {
                            ConsoleReporter.getInstance().reportOnceAndPause();
                            break;
                        }
                        ConsoleReporter.getInstance().resume(value);
                        break;
                    }
                    case 'f': {
                        int index;
                        String s = line.substring(1);
                        Vector parts = Utils.splitComma(s);
                        this.forceCalibrationPathExists(FILEPATH_CALIBRATION);
                        if (parts.isEmpty()) {
                            index = 1;
                            s = FileUtils.readTextFile(FILEPATH_CALIBRATION + index + ".ini");
                            if (s.length() != 0) {
                                System.out.println(s);
                            } else {
                                System.out.println("<none>");
                            }
                            System.out.println("OK");
                            break;
                        }
                        if (parts.size() < 1) continue block16;
                        index = Integer.parseInt((String)parts.elementAt(0));
                        if (parts.size() >= 2) {
                            FileUtils.writeTextFile(FILEPATH_CALIBRATION + index + ".ini", s);
                            System.out.println("OK - write calibration for A" + index);
                            break;
                        }
                        FileUtils.delete(FILEPATH_CALIBRATION + index + ".ini");
                        System.out.println("OK - erase calibration for A" + index);
                        break;
                    }
                    case 'i': {
                        for (int i = 0; i < this.vDeviceInfo.size(); ++i) {
                            System.out.println((String)this.vDeviceInfo.elementAt(i));
                        }
                        continue block16;
                    }
                    case 'l': {
                        String result;
                        String s = line.substring(1);
                        Vector parts = Utils.splitComma(s);
                        int index = Integer.parseInt((String)parts.elementAt(0));
                        int value = parts.size() > 1 ? Integer.parseInt((String)parts.elementAt(1)) : -1;
                        if (index == 1) {
                            if (value == -1) {
                                Slave.getInstance().overrideLedOut(false, 2);
                            } else {
                                Slave.getInstance().overrideLedOut(true, value);
                            }
                            result = "OK";
                        } else if (index == 2) {
                            if (value == -1) {
                                Slave.getInstance().overrideLedGsm(false, 2);
                            } else {
                                Slave.getInstance().overrideLedGsm(true, value);
                            }
                            result = "OK";
                        } else {
                            result = "ERROR - invalid index, available 1 (OUT) and 2 (GSM)";
                        }
                        System.out.println(result);
                        break;
                    }
                    case 'o': {
                        String result;
                        int value;
                        String s = line.substring(1);
                        Vector parts = Utils.splitComma(s);
                        int index = Integer.parseInt((String)parts.elementAt(0));
                        if (index == 0 || index == 2) {
                            value = Integer.parseInt((String)parts.elementAt(1));
                            result = Slave.getInstance().setOut(0, value);
                        } else {
                            result = "ERROR - invalid index, available 0 and 2";
                        }
                        System.out.println(result);
                        break;
                    }
                    case 'p': {
                        int value;
                        String s;
                        if (line.length() > 1) {
                            s = line.substring(1);
                            value = Integer.parseInt(s);
                        } else {
                            value = 0;
                        }
                        if (value == 0) {
                            Slave.getInstance().reportOnceAndPause();
                            break;
                        }
                        Slave.getInstance().resume(value);
                        break;
                    }
                    case 'q': {
                        System.out.println("Quit JAVA application.");
                        this.bRunning = false;
                        this.stopMidlet();
                        break;
                    }
                    case 'w': {
                        System.out.println("Sending command to HW Watchdog to reset ...");
                        Slave.getInstance().forceHwReset();
                        break;
                    }
                    case 'x': {
                        System.out.println("Entering sleep mode ...");
                        Slave.getInstance().sleep();
                        break;
                    }
                    case '#': {
                        bAuthorized = false;
                        Slave slave = Slave.getInstance();
                        slave.overrideLedOut(false, 2);
                        slave.overrideLedGsm(false, 2);
                        break;
                    }
                    default: {
                        System.out.println("--- HELP ------------------------------------------------");
                        System.out.println("a .. AT command, at+creg?");
                        System.out.println("c .. print configuration");
                        System.out.println("d .. print state, d1=start auto gpio info");
                        Console.sleep(100L);
                        System.out.println("f .. calibration write: f1,a,\"2015-12-14 15:13:00\",25.5,548");
                        System.out.println("                 erase: f1");
                        System.out.println("                 read:  f");
                        System.out.println("i .. system info");
                        Console.sleep(100L);
                        System.out.println("l .. LED control: l1,0 = LED OUT on; l1,0 = LED OUT off; l1=OUT; l2=GSM");
                        System.out.println("o .. swith output: o2,0   o2,1");
                        System.out.println("p .. print press debug info, p1=start, p0=once and stop ");
                        System.out.println("q .. switch off Java autostart and restart");
                        Console.sleep(100L);
                        System.out.println("w .. force HW watchdog to reset device");
                        System.out.println("x .. enter sleep mode");
                        System.out.println("# .. leave commmand mode");
                        System.out.println("---------------------------------------------------------");
                    }
                }
            }
            catch (Exception e) {
                Console.log("[ EXCEPTION ] - '" + e.toString() + "'", 2);
                e.printStackTrace();
            }
        }
        this.closePort();
        Console.log("Thread finished", 0);
    }

    private void openPort() throws IOException {
        this.commConn = (CommConnection)Connector.open((String)CONNECTION_STRING, (int)3, (boolean)true);
        this.ins = this.commConn.openInputStream();
    }

    private void closePort() {
        if (this.ins != null) {
            try {
                this.ins.close();
                this.ins = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.commConn != null) {
            try {
                this.commConn.close();
                this.commConn = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String readln(InputStream is) {
        int MAX_LINE_LENGTH = 256;
        int pos = 0;
        byte[] aLine = new byte[256];
        try {
            int c;
            while ((c = is.read()) >= 0 && c != 13 && c != 10) {
                if (pos >= 256) continue;
                aLine[pos++] = (byte)c;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new String(aLine, 0, pos);
    }

    void setDeviceInfo(Vector src) {
        this.vDeviceInfo = src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceCalibrationPathExists(String sPath) {
        FileConnection fconn = null;
        if (sPath.charAt(sPath.length() - 1) == '/') {
            sPath = sPath.substring(0, sPath.length() - 1);
        }
        try {
            fconn = (FileConnection)Connector.open((String)sPath, (int)3);
            if (!fconn.isDirectory()) {
                fconn.mkdir();
            }
        }
        catch (IOException e) {
            Console.log("[EXCEPTION] - " + e.getMessage(), 2);
        }
        finally {
            try {
                if (null != fconn) {
                    fconn.close();
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private void stopMidlet() {
        new Thread(){

            public void run() {
                Main.getInstance().destroyApp(true);
            }
        }.start();
    }
}

