/*
 * Decompiled with CFR 0.152.
 */
package com.sea.utils;

import com.sea.log.Logger;
import com.sea.modem.SyncAtCommand;
import com.sea.utils.Timed;
import com.sea.utils.WatchdogDeviceReset;
import java.util.Enumeration;
import java.util.Hashtable;

public class Watchdog
extends Thread {
    private long TIMEOUT_ALL_RESPONDING = 15000L;
    private static Watchdog instance = null;
    private static SyncAtCommand atc = null;
    private boolean bRunning = false;
    public static final int iLogLevel = 4;
    private Hashtable clients = new Hashtable();

    public static Watchdog getInstance() {
        if (instance == null) {
            instance = new Watchdog();
        }
        return instance;
    }

    public void registerAtCommand(SyncAtCommand aSyncAtCommand) {
        atc = aSyncAtCommand;
    }

    public void startRunning() {
        this.bRunning = true;
        this.start();
    }

    public void stopRunning() {
        this.bRunning = false;
        instance.interrupt();
    }

    protected static void log(String line) {
        Watchdog.log(line, 4);
    }

    protected static void log(String line, int level) {
        if (4 >= level) {
            Logger.log("@Watchdog", line);
        }
    }

    public void run() {
        long iLastAllReponding = Timed.currentTimeMillis();
        while (this.bRunning) {
            try {
                Watchdog.sleep(1000L);
                long iNow = Timed.currentTimeMillis();
                boolean bAllResponding = true;
                Enumeration e = this.clients.elements();
                while (e.hasMoreElements()) {
                    WatchdogClient wc = (WatchdogClient)e.nextElement();
                    if (!wc.ist(iNow)) continue;
                    bAllResponding = false;
                    Watchdog.log("[ERROR] - Client is not responding: " + wc.getName());
                }
                if (bAllResponding) {
                    iLastAllReponding = iNow;
                    continue;
                }
                if (iNow - iLastAllReponding < this.TIMEOUT_ALL_RESPONDING) continue;
                Watchdog.log("[ERROR] - Patience is over --> RESET");
                Watchdog.deviceReset();
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                Watchdog.log("[EXCEPTION] - " + e.getMessage());
                e.printStackTrace();
            }
        }
        Watchdog.log("Thread finished");
        instance = null;
    }

    public void register(Object client) {
        this.clients.put(client, new WatchdogClient(client.getClass().getName()));
    }

    public void kick(Object client, int nextLimit) {
        if (this.isAlive()) {
            try {
                WatchdogClient wc = (WatchdogClient)this.clients.get(client);
                wc.setNext(nextLimit);
            }
            catch (Exception e) {
                Watchdog.log("[EXCEPTION] - Unregisted client tries to use Watchdog, e - " + e.getMessage());
                e.printStackTrace();
                Watchdog.deviceReset();
            }
        }
    }

    public static void deviceReset() {
        new Thread(new WatchdogDeviceReset(atc)).start();
    }

    private class WatchdogClient {
        private long iNext = 0L;
        private String sName;

        public WatchdogClient(String name) {
            this.sName = name;
        }

        public boolean ist(long iNow) {
            return iNow >= this.iNext && this.iNext != 0L;
        }

        public void setNext(long value) {
            this.iNext = Timed.currentTimeMillis() + value * 1000L;
        }

        public String getName() {
            return this.sName;
        }
    }
}

