/*
 * Decompiled with CFR 0.152.
 */
package com.sea.utils;

import com.sea.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class FileUtils {
    public static int iLogLevel = 3;
    private static final String FILENAME_ROOT = "file:///A:/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(String sFilename) {
        InputStream is = null;
        FileConnection fc = null;
        String result = "";
        try {
            FileUtils.log("Readfing file '" + sFilename + "'.");
            fc = (FileConnection)Connector.open((String)sFilename, (int)3);
            if (fc.exists()) {
                int size = (int)fc.fileSize();
                is = fc.openInputStream();
                byte[] bytes = new byte[size];
                is.read(bytes, 0, size);
                result = new String(bytes, 0, size);
                FileUtils.log("Content '" + FileUtils.getPreview(result, 400) + "'.");
            }
        }
        catch (IOException ioe) {
            FileUtils.log("[EXCEPTION] - " + ioe.getMessage(), 2);
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
                if (null != fc) {
                    fc.close();
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFile(String sFilename, String sText) {
        OutputStream os = null;
        FileConnection fconn = null;
        try {
            FileUtils.log("Writing file '" + sFilename + "' with content '" + FileUtils.getPreview(sText, 400) + "'.");
            fconn = (FileConnection)Connector.open((String)sFilename, (int)3);
            if (!fconn.exists()) {
                fconn.create();
            }
            os = fconn.openOutputStream();
            os.write(sText.getBytes());
            fconn.setHidden(false);
        }
        catch (IOException e) {
            FileUtils.log("[EXCEPTION] - " + e.getMessage(), 2);
        }
        finally {
            try {
                if (null != os) {
                    os.close();
                }
                if (null != fconn) {
                    fconn.close();
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public static boolean delete(String sFilename) {
        boolean result = false;
        try {
            FileConnection fin = (FileConnection)Connector.open((String)sFilename);
            if (fin.exists()) {
                fin.delete();
                result = true;
            }
            fin.close();
        }
        catch (IOException e) {
            FileUtils.log("[EXCEPTION] - FileUtils.detele('" + sFilename + "'): " + e.getMessage(), 2);
        }
        return result;
    }

    public static void force(String sPath) {
        FileConnection fconn = null;
        if (sPath.charAt(sPath.length() - 1) == '/') {
            sPath = sPath.substring(0, sPath.length() - 1);
        }
        try {
            fconn = (FileConnection)Connector.open((String)sPath, (int)3);
            if (!fconn.isDirectory()) {
                FileUtils.log("Creating '" + sPath + "' because it did not exists.");
                fconn.mkdir();
            }
        }
        catch (IOException e) {
            FileUtils.log("[EXCEPTION] - " + e.getMessage(), 2);
        }
        finally {
            try {
                if (null != fconn) {
                    fconn.close();
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(String sFilename, long iOffset, int iLength) {
        InputStream is = null;
        FileConnection fc = null;
        byte[] result = new byte[]{};
        try {
            fc = (FileConnection)Connector.open((String)sFilename, (int)3);
            if (fc.exists()) {
                int size = (int)fc.fileSize();
                if (iOffset >= (long)size) {
                    byte[] byArray = new byte[]{};
                    return byArray;
                }
                is = fc.openInputStream();
                is.skip(iOffset);
                long remainingSize = (long)size - iOffset;
                long correctedLength = (long)iLength > remainingSize ? remainingSize : (long)iLength;
                byte[] bytes = new byte[(int)correctedLength];
                is.read(bytes, 0, bytes.length);
                result = bytes;
            }
        }
        catch (IOException ioe) {
            FileUtils.log("[EXCEPTION] - " + ioe.getMessage(), 2);
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
                if (null != fc) {
                    fc.close();
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int fileSize(String sFilename) {
        FileConnection fc = null;
        int result = 0;
        try {
            fc = (FileConnection)Connector.open((String)sFilename, (int)3);
            if (fc.exists()) {
                result = (int)fc.fileSize();
            }
        }
        catch (IOException ioe) {
            FileUtils.log("[EXCEPTION] - " + ioe.getMessage(), 2);
        }
        finally {
            try {
                if (null != fc) {
                    fc.close();
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(String filename) {
        FileConnection fc = null;
        boolean result = false;
        try {
            fc = (FileConnection)Connector.open((String)filename, (int)3);
            result = fc.exists();
        }
        catch (IOException ex) {
            FileUtils.log("[ERROR] - Cannot access file '" + filename + "' ex=" + ex.getMessage());
        }
        finally {
            try {
                if (null != fc) {
                    fc.close();
                }
            }
            catch (IOException e) {
                FileUtils.log(e.getMessage());
            }
        }
        return result;
    }

    private static void log(String line) {
        FileUtils.log(line, 4);
    }

    private static void log(String line, int level) {
        if (iLogLevel >= level) {
            Logger.log("@File", line);
        }
    }

    private static String getPreview(String src, int len) {
        if (len < src.length()) {
            return src.substring(0, len);
        }
        return src;
    }
}

