/*
 * Decompiled with CFR 0.152.
 */
package com.sea.gbgs5;

import com.cinterion.io.ATCommandFailedException;
import com.cinterion.io.OutPort;
import com.sea.gbgs5.Cfg;
import com.sea.gbgs5.Console;
import com.sea.gbgs5.ConsoleReporter;
import com.sea.gbgs5.Slave;
import com.sea.log.Logger;
import com.sea.modem.SyncAtCommand;
import com.sea.utils.FileUtils;
import com.sea.utils.Info;
import com.sea.utils.LanguageAbstract;
import com.sea.utils.LanguageEnglish;
import com.sea.utils.LineReader;
import com.sea.utils.Timed;
import com.sea.utils.Watchdog;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class Control
extends Thread {
    public static LanguageAbstract language = null;
    private static final int CTRL_INIT = 0;
    private static final int CTRL_CREATE = 10;
    private static final int CTRL_START = 20;
    private static final int CTRL_READY = 1000;
    private static final int CTRL_STOP = 2000;
    private static final int CTRL_FINISHED = 9999;
    private static final int READY_DELAY = 10000;
    private static final String FILENAME_SERIAL_NUMBER = "file:///A:/sn.txt";
    private static Control instance = null;
    private static boolean bRunning = false;
    public static final int iLogLevel = 4;
    private static int iMachine;
    private static boolean bWantedToStop;
    private static Vector vDeviceInfo;
    private static OutPort outp;
    private static Console consl;
    private static ConsoleReporter conslrep;
    private static Slave slave;
    private static Watchdog wdg;
    private Timer tmr1;
    private Info ttInfo;
    private static SyncAtCommand ata;
    private static SyncAtCommand atb;
    private static SyncAtCommand atc;

    public Control() {
        atc = null;
        atb = null;
        ata = null;
    }

    public static Control getInstance() {
        if (instance == null) {
            instance = new Control();
        }
        return instance;
    }

    public void startRunning() {
        bWantedToStop = false;
        bRunning = true;
        this.start();
    }

    public void stopRunning() {
        if (!bWantedToStop) {
            bWantedToStop = true;
            instance.interrupt();
        }
    }

    protected static void log(String line) {
        Control.log(line, 4);
    }

    protected static void log(String line, int level) {
        if (4 >= level) {
            Logger.log("@Control", line);
        }
    }

    public void run() {
        Control.log("Thread started");
        this.machineJumpTo(0);
        while (bRunning) {
            try {
                switch (iMachine) {
                    case 0: {
                        this.ctrlMachineInit();
                        break;
                    }
                    case 10: {
                        this.ctrlMachineCreate();
                        break;
                    }
                    case 20: {
                        this.ctrlMachineStart();
                        break;
                    }
                    case 1000: {
                        this.ctrlMachineReady();
                        break;
                    }
                    case 2000: {
                        this.ctrlMachineStop();
                        break;
                    }
                    case 9999: {
                        this.ctrlMachineFinished();
                        break;
                    }
                    default: {
                        this.machineJumpTo(0);
                        break;
                    }
                }
            }
            catch (Exception e) {
                Control.log("[EXCEPTION] - " + e.toString(), 2);
                e.printStackTrace();
                try {
                    Control.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!bWantedToStop || !bRunning) continue;
            this.machineJumpTo(2000);
        }
        Control.log("Thread finished.", 0);
    }

    private void ctrlMachineInit() {
        try {
            Control.log("Creating AT channel A");
            if (ata == null) {
                ata = new SyncAtCommand(false, "ata");
            }
            Control.log("Creating AT channel B");
            if (atb == null) {
                atb = new SyncAtCommand(true, "atb");
            }
            Control.log("Creating AT channel C");
            if (atc == null) {
                atc = new SyncAtCommand(false, "atc");
            }
        }
        catch (ATCommandFailedException ex) {
            Control.log("[ERROR] - Cannot create AT channels", 2);
        }
        this.selectStdout("USB");
        Cfg.init();
        Cfg.detectSerialNumber();
        vDeviceInfo = Control.prepareDeviceInfo();
        Control.printDeviceInfo(vDeviceInfo);
        if (Cfg.variant == 10 || Cfg.variant == 11) {
            this.enablePowerForRS485();
        }
        Control.log("Comm ports available='" + System.getProperty("microedition.commports") + "'");
        Control.log("Thread started.", 0);
        this.machineJumpTo(10);
    }

    private void ctrlMachineCreate() throws ATCommandFailedException, IOException {
        Control.log("Creating Language.");
        language = new LanguageEnglish();
        Control.log("Creating Console");
        consl = Console.getInstance();
        consl.registerAtCommand(atb);
        consl.setDeviceInfo(vDeviceInfo);
        conslrep = ConsoleReporter.getInstance();
        conslrep.registerAtCommand(atc);
        Control.log("Creating Watchdog.");
        wdg = Watchdog.getInstance();
        wdg.registerAtCommand(ata);
        Control.log("Creating Slave");
        slave = Slave.getInstance();
        this.tmr1 = new Timer();
        this.ttInfo = new Info();
        this.machineJumpTo(20);
    }

    private void ctrlMachineStart() {
        Control.log("Starting threads.");
        consl.startRunning();
        conslrep.startRunning();
        slave.startRunning();
        wdg.startRunning();
        this.tmr1.scheduleAtFixedRate((TimerTask)this.ttInfo, 0L, 10000L);
        this.machineJumpTo(1000);
    }

    private void ctrlMachineReady() {
        Control.log(this.getStatus(0), 0);
        Control.log(this.getStatus(1), 0);
        if (!wdg.isAlive() || !slave.isAlive()) {
            Watchdog.deviceReset();
        }
        this.delay(10000L);
    }

    private void ctrlMachineStop() {
        Vector<Thread> threads = new Vector<Thread>();
        Control.log("- Timer1(Info, UserLoger, EventScheduler)");
        if (this.tmr1 != null) {
            this.tmr1.cancel();
        }
        Control.log("Stopping threads:");
        try {
            if (wdg != null) {
                Control.log("- Watchdog");
                wdg.stopRunning();
                threads.addElement(wdg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (slave != null) {
                Control.log("- Slave");
                slave.stopRunning();
                threads.addElement(slave);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (conslrep != null) {
                Control.log("- Console Reporter");
                conslrep.stopRunning();
                threads.addElement(conslrep);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (consl != null) {
                Control.log("- Console");
                consl.stopRunning();
                threads.addElement(consl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Control.log("Waiting for all threads to die ...");
        boolean bAllIsTerminated = false;
        long lStartTime = Timed.currentTimeMillis();
        while (!bAllIsTerminated && !Timed.ist(lStartTime, 10000L)) {
            boolean bSomethingLives = false;
            Enumeration e = threads.elements();
            while (e.hasMoreElements()) {
                Thread t = (Thread)e.nextElement();
                if (!t.isAlive()) continue;
                bSomethingLives = true;
                Control.log(t.getClass() + " is ALIVE");
            }
            if (bSomethingLives) {
                Control.log("  wait ...");
                try {
                    Control.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            bAllIsTerminated = true;
        }
        Control.log("Releasing AT Channels");
        Control.log("- ATB");
        try {
            atb.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Control.log("- ATC1");
        this.selectStdout("USB1");
        Control.log("- ATC2");
        try {
            atc.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Control.log("- ATA");
        try {
            ata.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Control.log("Stop completed.");
        bRunning = false;
        this.machineJumpTo(9999);
    }

    private void ctrlMachineFinished() {
        bRunning = false;
    }

    private void delay(long millis) {
        try {
            Control.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void machineJumpTo(int aNewState) {
        iMachine = aNewState;
    }

    public static void printDeviceInfo(Vector src) {
        for (int i = 0; i < src.size(); ++i) {
            Control.log((String)src.elementAt(i), 0);
        }
    }

    public static Vector prepareDeviceInfo() {
        Vector<String> result = new Vector<String>(7);
        result.addElement("--- START --------------------------------------------------------");
        result.addElement("Product:       GBGS5TEST (C5-88-D9)");
        result.addElement("Version:       1.12");
        result.addElement("Manufacturer:  SEA s.r.o., Czech Republic");
        result.addElement("               www.seapraha.cz");
        result.addElement("Serial Number: " + Control.formatSerialNumber());
        result.addElement("------------------------------------------------------------------");
        return result;
    }

    private void detectSerialNumber() {
        String sResult = "";
        String sText = FileUtils.readTextFile(FILENAME_SERIAL_NUMBER);
        LineReader lReader = new LineReader(sText);
        String s = lReader.getLine();
        if (s != null && s.length() >= 3 && s.charAt(0) == 'G') {
            sResult = s.trim();
        }
        if (sResult.length() == 0) {
            sResult = "GC914001";
        }
        Cfg.SERIAL_NUMBER = sResult;
    }

    private static String formatSerialNumber() {
        if (Cfg.SERIAL_NUMBER.length() > 0) {
            return Cfg.SERIAL_NUMBER;
        }
        return "-";
    }

    private String getStatus(int _type) {
        String result = "";
        result = _type == 0 ? result + "A" : result + "  GBGS5TEST 1.12 " + Cfg.SERIAL_NUMBER;
        return result;
    }

    public void selectStdout(String destination) {
        try {
            atc.send("at^scfg=\"Userware/Stdout\",\"" + destination + "\"\r");
        }
        catch (ATCommandFailedException aTCommandFailedException) {
            // empty catch block
        }
    }

    static boolean isDeviceGsmKlic() {
        return Cfg.SERIAL_NUMBER.startsWith("GD1");
    }

    static boolean isDeviceGsmR2Ring() {
        return Cfg.SERIAL_NUMBER.startsWith("GD3");
    }

    static boolean isDeviceGsmR2T() {
        return Cfg.SERIAL_NUMBER.startsWith("GD2");
    }

    static boolean isDeviceGsmPress() {
        return Cfg.SERIAL_NUMBER.startsWith("GD7");
    }

    static boolean isDeviceGsmBgs5() {
        return Cfg.SERIAL_NUMBER.startsWith("GD5");
    }

    static boolean isDeviceGsmCmgsm() {
        return Cfg.SERIAL_NUMBER.startsWith("GD4");
    }

    static boolean isDeviceGsmR5MODBUS() {
        return Cfg.SERIAL_NUMBER.startsWith("GF8");
    }

    static boolean isDeviceGsmR5T() {
        return Cfg.SERIAL_NUMBER.startsWith("GF4");
    }

    private void enablePowerForRS485() {
        try {
            atc.send("at^scpin=1,22,1,1\r");
        }
        catch (ATCommandFailedException ex) {
            ex.printStackTrace();
        }
    }
}

