/*
 * Decompiled with CFR 0.152.
 */
package com.sea.gbgs5;

import com.cinterion.io.ATCommandFailedException;
import com.cinterion.io.InPort;
import com.cinterion.io.InPortListener;
import com.sea.gbgs5.Control;
import com.sea.gbgs5.Slave;
import com.sea.log.Logger;
import com.sea.modem.SyncAtCommand;
import com.sea.utils.Utils;
import java.io.IOException;
import java.util.Vector;

public class ConsoleReporter
extends Thread
implements InPortListener {
    private static ConsoleReporter instance;
    private boolean bRunning;
    private SyncAtCommand atc;
    public static final int iLogLevel = 4;
    private InPort inp;
    private int lastPortValue;
    private boolean bAuto = false;
    private int iAutoMode = 0;

    public static ConsoleReporter getInstance() {
        if (instance == null) {
            instance = new ConsoleReporter();
        }
        return instance;
    }

    public void startRunning() {
        this.bRunning = true;
        this.start();
    }

    public void stopRunning() {
        this.bRunning = false;
        this.interrupt();
    }

    protected static void log(String line) {
        ConsoleReporter.log(line, 4);
    }

    protected static void log(String line, int level) {
        if (4 >= level) {
            Logger.log("@Console", line);
        }
    }

    public void registerAtCommand(SyncAtCommand aSyncAtCommand) {
        this.atc = aSyncAtCommand;
    }

    public void run() {
        Vector<String> pins = new Vector<String>();
        pins.addElement("GPIO8");
        pins.addElement("GPIO7");
        try {
            this.inp = new InPort(pins);
            this.lastPortValue = this.inp.getValue();
            this.inp.addListener((InPortListener)this);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        while (this.bRunning) {
            try {
                try {
                    ConsoleReporter.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (!this.bAuto) continue;
                this.printReport();
            }
            catch (Exception e) {
                ConsoleReporter.log("[ EXCEPTION ] - '" + e.toString() + "'", 2);
                e.printStackTrace();
            }
        }
    }

    void reportOnceAndPause() {
        this.bAuto = false;
        this.printReport();
    }

    void resume(int mode) {
        this.iAutoMode = mode;
        this.bAuto = true;
        this.interrupt();
    }

    public void portValueChanged(int portValue) {
        this.lastPortValue = portValue;
        this.interrupt();
    }

    private int getAdc1Value() {
        int result = -1;
        try {
            String resp = this.atc.send("AT^SRADC=1\r");
            int pos1 = resp.indexOf("^SRADC:");
            int pos2 = resp.indexOf(":", pos1);
            int pos3 = resp.indexOf("\r", pos2);
            if (pos1 >= 0 && pos2 > pos1 && pos3 > pos2) {
                String s = resp.substring(pos2 + 1, pos3);
                Vector elements = Utils.splitComma(s);
                String value = (String)elements.elementAt(1);
                result = Integer.parseInt(value);
            }
        }
        catch (ATCommandFailedException ex) {
            ex.printStackTrace();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    private void printReport() {
        if (Control.isDeviceGsmKlic()) {
            ConsoleReporter.log("STATE - X1=" + (this.lastPortValue >> 1 & 1) + ";X2=" + (this.lastPortValue & 1) + ";Y3=" + Slave.getInstance().getOut() + ";A4=? ADC;");
        } else if (Control.isDeviceGsmR2Ring() || Control.isDeviceGsmR2T()) {
            ConsoleReporter.log("STATE - A1=" + this.getAdc1Value() + " ADC;X2=" + (this.lastPortValue & 1) + ";Y3=" + Slave.getInstance().getOut() + ";");
        } else if (Control.isDeviceGsmPress()) {
            ConsoleReporter.log("STATE - A1=? Pa;X2=" + this.lastPortValue + ";Y3=" + Slave.getInstance().getOut() + ";A4=? ADC;");
        } else if (Control.isDeviceGsmR5MODBUS() || Control.isDeviceGsmBgs5()) {
            ConsoleReporter.log("STATE - A1=?;Y2=" + Slave.getInstance().getOut() + ";X3=" + (this.lastPortValue & 1) + ";");
        } else if (Control.isDeviceGsmR5T()) {
            ConsoleReporter.log("STATE - A1=" + this.getAdc1Value() + ";Y2=" + Slave.getInstance().getOut() + ";X3=" + (this.lastPortValue & 1) + ";");
        } else {
            ConsoleReporter.log("STATE - X1=" + (this.lastPortValue >> 1 & 1) + ";Y2=" + Slave.getInstance().getOut() + ";");
        }
    }
}

